/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.thymeleaf.view;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.response.dispatch.AbstractViewDispatcher;
import com.aspectran.core.activity.response.dispatch.ViewDispatcherException;
import com.aspectran.core.adapter.ResponseAdapter;
import com.aspectran.core.context.rule.DispatchRule;
import com.aspectran.thymeleaf.ThymeleafTemplateEngine;
import com.aspectran.utils.Assert;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import org.thymeleaf.ITemplateEngine;

public class ThymeleafViewDispatcher
extends AbstractViewDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(ThymeleafViewDispatcher.class);
    private final ITemplateEngine templateEngine;

    public ThymeleafViewDispatcher(ThymeleafTemplateEngine thymeleafTemplateEngine) {
        Assert.notNull((Object)thymeleafTemplateEngine, "thymeleafTemplateEngine must not be null");
        this.templateEngine = thymeleafTemplateEngine.getTemplateEngine();
    }

    public ThymeleafViewDispatcher(ITemplateEngine templateEngine) {
        Assert.notNull((Object)templateEngine, "templateEngine must not be null");
        this.templateEngine = templateEngine;
    }

    @Override
    public void dispatch(Activity activity, DispatchRule dispatchRule) throws ViewDispatcherException {
        String viewName = null;
        try {
            String encoding;
            viewName = this.resolveViewName(dispatchRule, activity);
            ResponseAdapter responseAdapter = activity.getResponseAdapter();
            String contentType = dispatchRule.getContentType();
            if (contentType == null) {
                contentType = this.getContentType();
            }
            if (contentType != null) {
                responseAdapter.setContentType(contentType);
            }
            if ((encoding = dispatchRule.getEncoding()) == null && responseAdapter.getEncoding() == null) {
                encoding = activity.getTranslet().getDefinitiveResponseEncoding();
            }
            if (encoding != null) {
                responseAdapter.setEncoding(encoding);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Dispatching to Thymeleaf template [" + viewName + "]");
            }
            ThymeleafTemplateEngine.process(this.templateEngine, viewName, activity);
        }
        catch (Exception e) {
            activity.setRaisedException(e);
            throw new ViewDispatcherException("Failed to dispatch to Thymeleaf template " + dispatchRule.toString(this, viewName), e);
        }
    }
}

