/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityPrepareException;
import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.AdapterException;
import com.aspectran.core.activity.CoreActivity;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.activity.request.RequestParseException;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.undertow.adapter.TowRequestAdapter;
import com.aspectran.undertow.adapter.TowResponseAdapter;
import com.aspectran.undertow.adapter.TowSessionAdapter;
import com.aspectran.undertow.service.TowService;
import com.aspectran.utils.Assert;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.web.activity.request.WebRequestBodyParser;
import com.aspectran.web.adapter.WebRequestAdapter;
import com.aspectran.web.support.http.MediaType;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import java.io.UnsupportedEncodingException;

public class TowActivity
extends CoreActivity {
    private final HttpServerExchange exchange;
    private String requestName;
    private MethodType requestMethod;

    public TowActivity(@NonNull TowService service, HttpServerExchange exchange) {
        super(service.getActivityContext());
        this.exchange = exchange;
    }

    @Override
    public Activity.Mode getMode() {
        return Activity.Mode.WEB;
    }

    public HttpServerExchange getExchange() {
        return this.exchange;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public MethodType getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(MethodType requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getFullRequestName() {
        if (this.requestMethod != null && this.requestName != null) {
            return String.valueOf((Object)this.requestMethod) + " " + this.requestName;
        }
        return this.requestName != null ? this.requestName : "";
    }

    public void prepare() throws TransletNotFoundException, ActivityPrepareException {
        Assert.state(this.requestName != null, "requestName is not set");
        Assert.state(this.requestMethod != null, "requestMethod is not set");
        this.prepare(this.requestName, this.requestMethod);
    }

    @Override
    protected void prepare(String requestName, MethodType requestMethod, TransletRule transletRule) throws ActivityPrepareException {
        MethodType hiddenRequestMethod;
        String method;
        if (requestMethod == MethodType.POST && (method = this.exchange.getRequestHeaders().getFirst("X-Method-Override")) != null && (hiddenRequestMethod = MethodType.resolve(method)) != null) {
            requestMethod = hiddenRequestMethod;
        }
        super.prepare(requestName, requestMethod, transletRule);
    }

    @Override
    protected void adapt() throws AdapterException {
        try {
            String responseEncoding;
            if (this.getParentActivity() == null) {
                SessionManager sessionManager = (SessionManager)this.exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
                SessionConfig sessionConfig = (SessionConfig)this.exchange.getAttachment(SessionConfig.ATTACHMENT_KEY);
                if (sessionManager != null && sessionConfig != null) {
                    this.setSessionAdapter(new TowSessionAdapter(this.exchange));
                }
            } else {
                this.setSessionAdapter(this.getParentActivity().getSessionAdapter());
            }
            TowRequestAdapter requestAdapter = new TowRequestAdapter(this.getTranslet().getRequestMethod(), this.exchange);
            if (this.getParentActivity() == null) {
                String requestEncoding;
                String maxRequestSizeSetting = (String)this.getSetting("maxRequestSize");
                if (StringUtils.hasLength(maxRequestSizeSetting)) {
                    try {
                        long maxRequestSize = Long.parseLong(maxRequestSizeSetting);
                        if (maxRequestSize >= 0L) {
                            requestAdapter.setMaxRequestSize(maxRequestSize);
                            this.exchange.setMaxEntitySize(maxRequestSize);
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new RequestParseException("Illegal value for maxRequestSize: " + maxRequestSizeSetting, e);
                    }
                }
                if ((requestEncoding = this.getDefinitiveRequestEncoding()) != null) {
                    try {
                        requestAdapter.setEncoding(requestEncoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RequestParseException("Unable to set request encoding to " + requestEncoding, e);
                    }
                }
            }
            this.setRequestAdapter(requestAdapter);
            TowResponseAdapter responseAdapter = new TowResponseAdapter(this.exchange, this);
            if (this.getParentActivity() == null && (responseEncoding = this.getDefinitiveResponseEncoding()) != null) {
                responseAdapter.setEncoding(responseEncoding);
            }
            this.setResponseAdapter(responseAdapter);
        }
        catch (Exception e) {
            throw new AdapterException("Failed to adapt for the tow activity", e);
        }
        super.adapt();
    }

    @Override
    public WebRequestAdapter getRequestAdapter() {
        return (WebRequestAdapter)super.getRequestAdapter();
    }

    @Override
    protected void parseRequest() throws ActivityTerminatedException, RequestParseException {
        if (this.getParentActivity() == null) {
            this.getRequestAdapter().preparse();
        } else {
            this.getRequestAdapter().preparse((WebRequestAdapter)this.getParentActivity().getRequestAdapter());
        }
        MediaType mediaType = this.getRequestAdapter().getMediaType();
        if (mediaType != null) {
            if (WebRequestBodyParser.isMultipartForm(this.getRequestAdapter().getRequestMethod(), mediaType)) {
                WebRequestBodyParser.parseMultipartFormData(this);
            } else if (WebRequestBodyParser.isURLEncodedForm(mediaType)) {
                WebRequestBodyParser.parseURLEncodedFormData(this.getRequestAdapter());
            }
        }
        super.parseRequest();
    }
}

