/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.adapter;

import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.utils.MultiValueMap;
import com.aspectran.utils.StringUtils;
import com.aspectran.web.adapter.AbstractWebRequestAdapter;
import com.aspectran.web.adapter.WebRequestAdapter;
import com.aspectran.web.support.http.MediaType;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.HeaderMap;
import io.undertow.util.HeaderValues;
import io.undertow.util.Headers;
import io.undertow.util.LocaleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class TowRequestAdapter
extends AbstractWebRequestAdapter {
    private boolean headersObtained;

    public TowRequestAdapter(MethodType requestMethod, HttpServerExchange exchange) {
        super(requestMethod, exchange);
    }

    @Override
    public MultiValueMap<String, String> getHeaderMap() {
        if (!this.headersObtained) {
            this.headersObtained = true;
            HeaderMap headerMap = this.getHttpServerExchange().getRequestHeaders();
            if (headerMap.size() > 0) {
                MultiValueMap<String, String> multiValueMap = super.getHeaderMap();
                for (HeaderValues headerValues : headerMap) {
                    String name = headerValues.getHeaderName().toString();
                    for (String value : headerValues) {
                        multiValueMap.add(name, value);
                    }
                }
            }
        }
        return super.getHeaderMap();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.getHttpServerExchange().isBlocking()) {
            this.getHttpServerExchange().startBlocking();
        }
        return this.getHttpServerExchange().getInputStream();
    }

    private HttpServerExchange getHttpServerExchange() {
        return (HttpServerExchange)this.getAdaptee();
    }

    @Override
    public void preparse() {
        String acceptLanguage;
        List locales;
        HttpServerExchange exchange = (HttpServerExchange)this.getAdaptee();
        for (Map.Entry entry : exchange.getQueryParameters().entrySet()) {
            String name = (String)entry.getKey();
            String[] values = ((Deque)entry.getValue()).toArray(new String[0]);
            this.getParameterMap().put(name, values);
        }
        String contentType = exchange.getRequestHeaders().getFirst(Headers.CONTENT_TYPE);
        if (StringUtils.hasLength(contentType)) {
            try {
                MediaType mediaType = MediaType.parseMediaType(contentType);
                this.setMediaType(mediaType);
                if (mediaType.getCharset() != null) {
                    this.setEncoding(mediaType.getCharset().name());
                }
            }
            catch (Exception mediaType) {
                // empty catch block
            }
        }
        if (!(locales = LocaleUtils.getLocalesFromHeader((String)(acceptLanguage = exchange.getRequestHeaders().getFirst(Headers.ACCEPT_LANGUAGE)))).isEmpty()) {
            this.setLocale((Locale)locales.get(0));
        }
    }

    @Override
    public void preparse(WebRequestAdapter requestAdapter) {
        if (requestAdapter == this) {
            throw new IllegalStateException("Unable To Replicate");
        }
        this.setAttributeMap(requestAdapter.getAttributeMap());
        this.getParameterMap().putAll(requestAdapter.getParameterMap());
        this.setMediaType(requestAdapter.getMediaType());
        this.setLocale(requestAdapter.getLocale());
    }
}

