/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.adapter;

import com.aspectran.core.adapter.AbstractSessionAdapter;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import java.util.Collections;
import java.util.Enumeration;

public class TowSessionAdapter
extends AbstractSessionAdapter {
    private boolean newSession;

    public TowSessionAdapter(HttpServerExchange exchange) {
        super(exchange);
    }

    @Override
    public <T> T getAdaptee() {
        return (T)this.getSession(true);
    }

    @Override
    public String getId() {
        return this.getSession(true).getId();
    }

    @Override
    public long getCreationTime() {
        return this.getSession(true).getCreationTime();
    }

    @Override
    public long getLastAccessedTime() {
        return this.getSession(true).getLastAccessedTime();
    }

    @Override
    public int getMaxInactiveInterval() {
        return this.getSession(true).getMaxInactiveInterval();
    }

    @Override
    public void setMaxInactiveInterval(int interval) {
        this.getSession(true).setMaxInactiveInterval(interval);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        Session session = this.getSession(false);
        if (session != null) {
            return Collections.enumeration(session.getAttributeNames());
        }
        return null;
    }

    @Override
    public <T> T getAttribute(String name) {
        Session session = this.getSession(false);
        if (session != null) {
            return (T)session.getAttribute(name);
        }
        return null;
    }

    @Override
    public void setAttribute(String name, Object value) {
        if (value != null) {
            Session session = this.getSession(true);
            session.setAttribute(name, value);
        } else {
            Session session = this.getSession(false);
            if (session != null) {
                session.removeAttribute(name);
            }
        }
    }

    @Override
    public void removeAttribute(String name) {
        Session session = this.getSession(false);
        if (session != null) {
            session.removeAttribute(name);
        }
    }

    @Override
    public void invalidate() {
        Session session = this.getSession(false);
        if (session != null) {
            session.invalidate((HttpServerExchange)this.getAdaptee());
        }
    }

    @Override
    public boolean isValid() {
        Session session = this.getSession(false);
        return session != null;
    }

    @Override
    public boolean isNew() {
        Session session = this.getSession(false);
        return session == null || this.newSession;
    }

    public Session getSession(boolean create) {
        HttpServerExchange exchange = (HttpServerExchange)super.getAdaptee();
        SessionManager sessionManager = (SessionManager)exchange.getAttachment(SessionManager.ATTACHMENT_KEY);
        SessionConfig sessionConfig = (SessionConfig)exchange.getAttachment(SessionConfig.ATTACHMENT_KEY);
        if (sessionConfig == null || sessionManager == null) {
            return null;
        }
        Session session = sessionManager.getSession(exchange, sessionConfig);
        if (session == null && create) {
            this.newSession = true;
            return sessionManager.createSession(exchange, sessionConfig);
        }
        return session;
    }
}

