/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.daemon.command;

import com.aspectran.core.activity.request.ParameterMap;
import com.aspectran.core.component.bean.BeanException;
import com.aspectran.core.component.bean.BeanRegistry;
import com.aspectran.core.context.asel.item.ItemEvaluator;
import com.aspectran.core.context.rule.ItemRuleMap;
import com.aspectran.daemon.command.AbstractCommand;
import com.aspectran.daemon.command.Command;
import com.aspectran.daemon.command.CommandParameters;
import com.aspectran.daemon.command.CommandRegistry;
import com.aspectran.daemon.command.CommandResult;
import com.aspectran.undertow.server.TowServer;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.net.BindException;

public class UndertowCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "undertow";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public UndertowCommand(CommandRegistry registry) {
        super(registry);
    }

    @Override
    public CommandResult execute(CommandParameters parameters) {
        try {
            String mode = null;
            String serverName = null;
            ItemRuleMap parameterItemRuleMap = parameters.getParameterItemRuleMap();
            if (parameterItemRuleMap != null && !parameterItemRuleMap.isEmpty()) {
                ItemEvaluator evaluator = this.getDaemonService().getDefaultActivity().getItemEvaluator();
                ParameterMap parameterMap = evaluator.evaluateAsParameterMap(parameterItemRuleMap);
                mode = parameterMap.getParameter("mode");
                serverName = parameterMap.getParameter("server");
            }
            if (mode == null) {
                return this.failed("'mode' parameter is not specified");
            }
            if (!StringUtils.hasLength(serverName)) {
                serverName = "tow.server";
            }
            switch (mode) {
                case "start": {
                    return this.startTowServer(serverName);
                }
                case "stop": {
                    return this.stopTowServer(serverName);
                }
                case "restart": {
                    CommandResult commandResult = this.stopTowServer(serverName);
                    if (commandResult.isSuccess()) {
                        commandResult = this.startTowServer(serverName);
                    }
                    return commandResult;
                }
                case "status": {
                    return this.printServerStatus(serverName);
                }
            }
            return this.failed(this.error("Unknown mode '" + mode + "'"));
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    private CommandResult startTowServer(String serverName) throws Exception {
        TowServer towServer = null;
        try {
            if (this.hasTowServer(serverName)) {
                towServer = this.getTowServer(serverName);
                if (towServer.isRunning()) {
                    return this.failed(this.warn("Undertow server is already running"));
                }
                towServer.start();
                return this.success(this.info(this.getStatus(towServer.getState())));
            }
            towServer = this.getTowServer(serverName);
            if (!towServer.isRunning()) {
                towServer.start();
            }
            return this.success(this.info(this.getStatus(towServer.getState())));
        }
        catch (Exception e) {
            Throwable cause;
            if (towServer != null) {
                this.destroyTowServer(towServer);
            }
            if ((cause = ExceptionUtils.getRootCause(e)) instanceof BindException) {
                return this.failed("Undertow server failed to start. Cause: Port already in use", e);
            }
            return this.failed(e);
        }
    }

    private CommandResult stopTowServer(String serverName) {
        try {
            if (this.hasTowServer(serverName)) {
                TowServer towServer = this.getTowServer(serverName);
                this.destroyTowServer(towServer);
                return this.success(this.info(this.getStatus("STOPPED")));
            }
            return this.failed(this.warn("Undertow server is not running"));
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    private CommandResult printServerStatus(String serverName) {
        try {
            if (this.hasTowServer(serverName)) {
                TowServer towServer = this.getTowServer(serverName);
                if (towServer.isStarted()) {
                    return this.success(this.info(this.getStatus("RUNNING")));
                }
                return this.success(this.info(this.getStatus(towServer.getState())));
            }
            return this.success(this.info(this.getStatus("STOPPED")));
        }
        catch (BeanException e) {
            return this.failed("Undertow server is not available", e);
        }
        catch (Exception e) {
            return this.failed(e);
        }
    }

    @NonNull
    private String getStatus(String status) {
        return status + " - Undertow " + TowServer.getVersion();
    }

    private TowServer getTowServer(String serverName) {
        BeanRegistry beanRegistry = this.getDaemonService().getActivityContext().getBeanRegistry();
        return beanRegistry.getBean(TowServer.class, serverName);
    }

    private boolean hasTowServer(String serverName) {
        BeanRegistry beanRegistry = this.getDaemonService().getActivityContext().getBeanRegistry();
        return beanRegistry.hasSingleton(TowServer.class, serverName);
    }

    private void destroyTowServer(TowServer towServer) throws Exception {
        BeanRegistry beanRegistry = this.getDaemonService().getActivityContext().getBeanRegistry();
        beanRegistry.destroySingleton(towServer);
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return UndertowCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return UndertowCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Use the command 'undertow' to control the Undertow server";
        }
    }
}

