/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server;

import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.undertow.server.AjpListenerConfig;
import com.aspectran.undertow.server.HttpListenerConfig;
import com.aspectran.undertow.server.HttpsListenerConfig;
import com.aspectran.undertow.server.TowOptions;
import com.aspectran.undertow.server.TowServer;
import com.aspectran.undertow.server.session.TowSessionManager;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.lifecycle.AbstractLifeCycle;
import io.undertow.Undertow;
import io.undertow.server.HttpHandler;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.Deployment;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;
import java.io.IOException;
import org.xnio.Option;
import org.xnio.OptionMap;

public abstract class AbstractTowServer
extends AbstractLifeCycle
implements TowServer {
    private final Undertow.Builder builder = Undertow.builder();
    private ServletContainer servletContainer;
    private HttpHandler handler;
    private boolean autoStart;
    private int shutdownTimeoutSecs;

    public Undertow.Builder getBuilder() {
        return this.builder;
    }

    public void setHttpListeners(HttpListenerConfig ... httpListenerConfigs) {
        if (httpListenerConfigs == null) {
            throw new IllegalArgumentException("httpListenerConfigs must not be null");
        }
        for (HttpListenerConfig listenerConfig : httpListenerConfigs) {
            this.builder.addListener(listenerConfig.getListenerBuilder());
        }
    }

    public void setHttpsListeners(HttpsListenerConfig ... httpsListenerConfigs) throws IOException {
        if (httpsListenerConfigs == null) {
            throw new IllegalArgumentException("httpsListenerConfigs must not be null");
        }
        for (HttpsListenerConfig listenerConfig : httpsListenerConfigs) {
            this.builder.addListener(listenerConfig.getListenerBuilder());
        }
    }

    public void setAjpListeners(AjpListenerConfig ... ajpListenerConfigs) {
        if (ajpListenerConfigs == null) {
            throw new IllegalArgumentException("ajpListenerConfigs must not be null");
        }
        for (AjpListenerConfig listenerConfig : ajpListenerConfigs) {
            this.builder.addListener(listenerConfig.getListenerBuilder());
        }
    }

    public void setBufferSize(int bufferSize) {
        this.builder.setBufferSize(bufferSize);
    }

    public void setIoThreads(int ioThreads) {
        this.builder.setIoThreads(ioThreads);
    }

    public void setWorkerThreads(int workerThreads) {
        this.builder.setWorkerThreads(workerThreads);
    }

    public void setDirectBuffers(boolean directBuffers) {
        this.builder.setDirectBuffers(directBuffers);
    }

    public <T> void setServerOption(Option<T> option, T value) {
        this.builder.setServerOption(option, value);
    }

    public <T> void setSocketOption(Option<T> option, T value) {
        this.builder.setSocketOption(option, value);
    }

    public <T> void setWorkerOption(Option<T> option, T value) {
        this.builder.setWorkerOption(option, value);
    }

    public void setServerOptions(TowOptions options) {
        if (options != null) {
            OptionMap optionMap = options.getOptionMap();
            for (Option option : optionMap) {
                this.builder.setServerOption(option, optionMap.get(option));
            }
        }
    }

    public void setSocketOptions(TowOptions options) {
        if (options != null) {
            OptionMap optionMap = options.getOptionMap();
            for (Option option : optionMap) {
                this.builder.setSocketOption(option, optionMap.get(option));
            }
        }
    }

    public void setWorkerOptions(TowOptions options) {
        if (options != null) {
            OptionMap optionMap = options.getOptionMap();
            for (Option option : optionMap) {
                this.builder.setWorkerOption(option, optionMap.get(option));
            }
        }
    }

    public HttpHandler getHandler() {
        return this.handler;
    }

    public void setHandler(HttpHandler handler) {
        this.handler = handler;
        this.builder.setHandler(handler);
    }

    public ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    public void setServletContainer(ServletContainer servletContainer) {
        this.servletContainer = servletContainer;
    }

    @Override
    public boolean isAutoStart() {
        return this.autoStart;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public int getShutdownTimeoutSecs() {
        return this.shutdownTimeoutSecs;
    }

    public void setShutdownTimeoutSecs(int shutdownTimeoutSecs) {
        this.shutdownTimeoutSecs = shutdownTimeoutSecs;
    }

    public void setSystemProperty(String key, String value) {
        System.setProperty(key, value);
    }

    @Override
    public DeploymentManager getDeploymentManager(String deploymentName) {
        if (this.getServletContainer() == null) {
            throw new IllegalStateException("servletContainer is not set");
        }
        if (deploymentName == null) {
            throw new IllegalArgumentException("deploymentName must not be null");
        }
        return this.getServletContainer().getDeployment(deploymentName);
    }

    @Override
    public DeploymentManager getDeploymentManagerByPath(String path) {
        if (this.getServletContainer() == null) {
            throw new IllegalStateException("servletContainer is not set");
        }
        if (path == null) {
            throw new IllegalArgumentException("path must not be null");
        }
        return this.getServletContainer().getDeploymentByPath(path);
    }

    @Override
    public SessionHandler getSessionHandler(String deploymentName) {
        DeploymentManager deploymentManager = this.getDeploymentManager(deploymentName);
        if (deploymentManager == null) {
            throw new IllegalStateException("Deployment named '" + deploymentName + "' not found");
        }
        SessionHandler sessionHandler = this.getSessionHandler(deploymentManager);
        if (sessionHandler == null) {
            throw new IllegalStateException("No SessionHandler for the deployment named '" + deploymentName + "'");
        }
        return sessionHandler;
    }

    @Override
    public SessionHandler getSessionHandlerByPath(String path) {
        DeploymentManager deploymentManager = this.getDeploymentManagerByPath(path);
        if (deploymentManager == null) {
            throw new IllegalStateException("Deployment with path '" + path + "' not found");
        }
        SessionHandler sessionHandler = this.getSessionHandler(deploymentManager);
        if (sessionHandler == null) {
            throw new IllegalStateException("No SessionHandler for the deployment with path " + path + "'");
        }
        return sessionHandler;
    }

    @Nullable
    private SessionHandler getSessionHandler(@NonNull DeploymentManager deploymentManager) {
        SessionManager sessionManager;
        Deployment deployment = deploymentManager.getDeployment();
        if (deployment != null && (sessionManager = deployment.getSessionManager()) instanceof TowSessionManager) {
            TowSessionManager towSessionManager = (TowSessionManager)sessionManager;
            return towSessionManager.getSessionHandler();
        }
        return null;
    }
}

