/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.handler;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import java.util.Arrays;
import java.util.List;
import java.util.ListIterator;

public abstract class AbstractRequestHandlerFactory {
    private List<HandlerWrapper> handlerChainWrappers;

    public void setHandlerChainWrappers(HandlerWrapper[] handlerWrappers) {
        if (handlerWrappers == null || handlerWrappers.length == 0) {
            throw new IllegalArgumentException("handlerWrappers must not be null or empty");
        }
        this.handlerChainWrappers = Arrays.asList(handlerWrappers);
    }

    protected HttpHandler wrapHandler(HttpHandler handler) {
        if (this.handlerChainWrappers != null) {
            HttpHandler current = handler;
            ListIterator<HandlerWrapper> iterator = this.handlerChainWrappers.listIterator(this.handlerChainWrappers.size());
            while (iterator.hasPrevious()) {
                HandlerWrapper wrapper = iterator.previous();
                current = wrapper.wrap(current);
            }
            return current;
        }
        return handler;
    }
}

