/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.handler;

import com.aspectran.undertow.server.handler.AbstractRequestHandlerFactory;
import com.aspectran.undertow.server.handler.resource.TowResourceHandler;
import com.aspectran.undertow.server.handler.session.SessionAttachmentHandler;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.ServletContainer;

public class DefaultRequestHandlerFactory
extends AbstractRequestHandlerFactory {
    private ServletContainer servletContainer;

    public ServletContainer getServletContainer() {
        return this.servletContainer;
    }

    public void setServletContainer(ServletContainer servletContainer) {
        if (servletContainer == null) {
            throw new IllegalArgumentException("servletContainer must not be null");
        }
        this.servletContainer = servletContainer;
    }

    public HttpHandler createHandler() throws Exception {
        ResponseCodeHandler rootHandler;
        if (this.servletContainer != null) {
            PathHandler pathHandler = new PathHandler();
            for (String deploymentName : this.servletContainer.listDeployments()) {
                DeploymentManager manager = this.servletContainer.getDeployment(deploymentName);
                Object handler = manager.start();
                SessionManager sessionManager = manager.getDeployment().getSessionManager();
                if (sessionManager != null) {
                    SessionConfig sessionConfig = manager.getDeployment().getServletContext().getSessionConfig();
                    handler = new SessionAttachmentHandler((HttpHandler)handler, sessionManager, sessionConfig);
                }
                DeploymentInfo info = manager.getDeployment().getDeploymentInfo();
                String contextPath = info.getContextPath();
                ResourceManager resourceManager = info.getResourceManager();
                if (resourceManager != null) {
                    TowResourceHandler resourceHandler = new TowResourceHandler(resourceManager, (HttpHandler)handler);
                    String pathPrefix = contextPath;
                    if (pathPrefix != null && pathPrefix.endsWith("/")) {
                        pathPrefix = pathPrefix.substring(0, pathPrefix.length() - 1);
                    }
                    resourceHandler.autoDetect(pathPrefix);
                    if (resourceHandler.hasPatterns()) {
                        handler = resourceHandler;
                    }
                }
                pathHandler.addPrefixPath(contextPath, handler);
            }
            rootHandler = pathHandler;
        } else {
            rootHandler = ResponseCodeHandler.HANDLE_404;
        }
        return this.wrapHandler((HttpHandler)rootHandler);
    }
}

