/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.handler.logging;

import com.aspectran.undertow.server.handler.logging.ExchangeLoggingGroupHelper;
import com.aspectran.undertow.server.handler.logging.LoggingGroupCompletionListener;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.wildcard.WildcardPatterns;
import io.undertow.server.ExchangeCompletionListener;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import java.util.Map;

public class PathBasedLoggingGroupHandler
implements HttpHandler {
    protected final ExchangeCompletionListener exchangeCompletionListener = new LoggingGroupCompletionListener();
    private final HttpHandler handler;
    private final Map<String, WildcardPatterns> pathPatternsByGroupName;

    public PathBasedLoggingGroupHandler(HttpHandler handler, Map<String, WildcardPatterns> pathPatternsByGroupName) {
        this.handler = handler;
        this.pathPatternsByGroupName = pathPatternsByGroupName;
    }

    public void handleRequest(@NonNull HttpServerExchange exchange) throws Exception {
        String groupName = this.resolveGroupName(exchange);
        ExchangeLoggingGroupHelper.setTo(exchange, groupName);
        exchange.addExchangeCompleteListener(this.exchangeCompletionListener);
        this.handler.handleRequest(exchange);
    }

    protected String resolveGroupName(@NonNull HttpServerExchange exchange) {
        String groupName = null;
        if (this.pathPatternsByGroupName != null && !this.pathPatternsByGroupName.isEmpty()) {
            String requestPath = exchange.getRequestPath();
            for (Map.Entry<String, WildcardPatterns> entry : this.pathPatternsByGroupName.entrySet()) {
                WildcardPatterns patterns = entry.getValue();
                if (!patterns.matches(requestPath)) continue;
                groupName = entry.getKey();
                break;
            }
        }
        return groupName;
    }
}

