/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.handler.logging;

import com.aspectran.undertow.server.handler.logging.PathBasedLoggingGroupHandler;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.wildcard.WildcardPatterns;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import java.util.HashMap;
import java.util.Map;

public class PathBasedLoggingGroupHandlerWrapper
implements HandlerWrapper {
    private Map<String, WildcardPatterns> pathPatternsByGroupName;

    public void setPathPatternsByGroupName(Map<String, String> pathPatternsByGroupName) {
        if (pathPatternsByGroupName != null) {
            HashMap<String, WildcardPatterns> map = new HashMap<String, WildcardPatterns>();
            for (Map.Entry<String, String> entry : pathPatternsByGroupName.entrySet()) {
                String groupName = entry.getKey();
                String[] arr = StringUtils.tokenize(entry.getValue(), ",;\t\r\n\f", true);
                if (arr.length <= 0) continue;
                WildcardPatterns pathPatterns = WildcardPatterns.of(arr, '/');
                map.put(groupName, pathPatterns);
            }
            this.pathPatternsByGroupName = map.isEmpty() ? null : map;
        } else {
            this.pathPatternsByGroupName = null;
        }
    }

    public HttpHandler wrap(HttpHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("handler must not be null");
        }
        return new PathBasedLoggingGroupHandler(handler, this.pathPatternsByGroupName);
    }
}

