/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.servlet;

import com.aspectran.undertow.server.servlet.TowFilterMapping;
import com.aspectran.undertow.server.servlet.TowFilterServletMapping;
import com.aspectran.undertow.server.servlet.TowFilterUrlMapping;
import com.aspectran.utils.ClassUtils;
import io.undertow.servlet.api.FilterInfo;
import jakarta.servlet.Filter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class TowFilter
extends FilterInfo {
    private TowFilterUrlMapping[] urlMappings;
    private TowFilterServletMapping[] servletMappings;

    public TowFilter(String name, String filterClass) throws ClassNotFoundException {
        this(name, ClassUtils.loadClass(filterClass));
    }

    public TowFilter(String name, Class<? extends Filter> filterClass) {
        super(name, filterClass);
    }

    public TowFilterUrlMapping[] getUrlMappings() {
        return this.urlMappings;
    }

    public void setMappingUrls(String[] mappingUrls) {
        if (mappingUrls != null) {
            ArrayList<TowFilterMapping> mappingList = new ArrayList<TowFilterMapping>(mappingUrls.length);
            for (String url : mappingUrls) {
                mappingList.add(new TowFilterMapping(url));
            }
            this.setUrlMappings(mappingList.toArray(new TowFilterMapping[0]));
        }
    }

    public void setUrlMappings(TowFilterMapping[] towFilterMappings) {
        if (towFilterMappings != null) {
            ArrayList<TowFilterUrlMapping> urlMappingList;
            if (this.urlMappings != null) {
                urlMappingList = new ArrayList(this.servletMappings.length + towFilterMappings.length);
                urlMappingList.addAll(Arrays.asList(this.urlMappings));
            } else {
                urlMappingList = new ArrayList<TowFilterUrlMapping>(towFilterMappings.length);
            }
            for (TowFilterMapping mapping : towFilterMappings) {
                urlMappingList.addAll(TowFilterUrlMapping.of(this.getName(), mapping));
            }
            this.urlMappings = urlMappingList.toArray(new TowFilterUrlMapping[0]);
        }
    }

    public TowFilterServletMapping[] getServletMappings() {
        return this.servletMappings;
    }

    public void setMappingServlets(String[] mappingServlets) {
        if (mappingServlets != null) {
            ArrayList<TowFilterMapping> mappingList = new ArrayList<TowFilterMapping>(mappingServlets.length);
            for (String servletName : mappingServlets) {
                mappingList.add(new TowFilterMapping(servletName));
            }
            this.setServletMappings(mappingList.toArray(new TowFilterMapping[0]));
        }
    }

    public void setServletMappings(TowFilterMapping[] towFilterMappings) {
        if (towFilterMappings != null) {
            ArrayList<TowFilterServletMapping> servletMappingList;
            if (this.servletMappings != null) {
                servletMappingList = new ArrayList(this.servletMappings.length + towFilterMappings.length);
                servletMappingList.addAll(Arrays.asList(this.servletMappings));
            } else {
                servletMappingList = new ArrayList<TowFilterServletMapping>(towFilterMappings.length);
            }
            for (TowFilterMapping towFilterMapping : towFilterMappings) {
                servletMappingList.addAll(TowFilterServletMapping.of(this.getName(), towFilterMapping));
            }
            this.servletMappings = servletMappingList.toArray(new TowFilterServletMapping[0]);
        }
    }

    public void setInitParams(Map<String, String> initParams) {
        if (initParams != null) {
            for (Map.Entry<String, String> entry : initParams.entrySet()) {
                this.addInitParam(entry.getKey(), entry.getValue());
            }
        }
    }
}

