/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.servlet;

import com.aspectran.undertow.server.servlet.TowFilterMapping;
import com.aspectran.utils.annotation.jsr305.NonNull;
import io.undertow.servlet.api.FilterMappingInfo;
import jakarta.servlet.DispatcherType;
import java.util.ArrayList;
import java.util.List;

public class TowFilterServletMapping
extends FilterMappingInfo {
    TowFilterServletMapping(String filterName, String mapping) {
        this(filterName, mapping, DispatcherType.REQUEST);
    }

    TowFilterServletMapping(String filterName, String mapping, DispatcherType dispatcher) {
        super(filterName, FilterMappingInfo.MappingType.SERVLET, mapping, dispatcher);
    }

    @NonNull
    static List<TowFilterServletMapping> of(String filterName, @NonNull TowFilterMapping towFilterMapping) {
        DispatcherType[] dispatchers = towFilterMapping.getDispatchers();
        ArrayList<TowFilterServletMapping> list = new ArrayList<TowFilterServletMapping>(dispatchers.length);
        for (DispatcherType dispatcherType : dispatchers) {
            list.add(new TowFilterServletMapping(filterName, towFilterMapping.getTarget(), dispatcherType));
        }
        return list;
    }
}

