/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.servlet;

import com.aspectran.core.adapter.ApplicationAdapter;
import com.aspectran.core.component.bean.annotation.AvoidAdvice;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.service.CoreService;
import com.aspectran.undertow.server.servlet.TowErrorPage;
import com.aspectran.undertow.server.servlet.TowFilter;
import com.aspectran.undertow.server.servlet.TowListener;
import com.aspectran.undertow.server.servlet.TowServlet;
import com.aspectran.undertow.server.servlet.TowWebSocketInitializer;
import com.aspectran.undertow.server.session.TowSessionManager;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.web.service.DefaultWebService;
import com.aspectran.web.service.DefaultWebServiceBuilder;
import com.aspectran.web.service.WebServiceClassLoader;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.session.SessionManager;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterMappingInfo;
import io.undertow.servlet.api.InstanceFactory;
import io.undertow.servlet.api.ServletContainerInitializerInfo;
import io.undertow.servlet.api.ServletInfo;
import io.undertow.servlet.util.ImmediateInstanceFactory;
import jakarta.servlet.ServletContainerInitializer;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class TowServletContext
extends DeploymentInfo
implements ActivityContextAware {
    private static final Set<Class<?>> NO_CLASSES = Collections.emptySet();
    private ActivityContext context;
    private SessionManager sessionManager;

    @NonNull
    public ActivityContext getActivityContext() {
        return this.context;
    }

    @Override
    @AvoidAdvice
    public void setActivityContext(@NonNull ActivityContext context) {
        this.context = context;
        WebServiceClassLoader webServiceClassLoader = new WebServiceClassLoader(context.getClassLoader());
        this.setClassLoader(webServiceClassLoader);
    }

    @NonNull
    public ApplicationAdapter getApplicationAdapter() {
        return this.getActivityContext().getApplicationAdapter();
    }

    public void setScratchDir(String scratchDir) throws IOException {
        File dir = this.getApplicationAdapter().toRealPathAsFile(scratchDir);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        this.setTempDir(this.getApplicationAdapter().toRealPathAsFile(scratchDir));
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
        this.setSessionManagerFactory(deployment -> {
            if (sessionManager instanceof TowSessionManager) {
                TowSessionManager towSessionManager = (TowSessionManager)sessionManager;
                towSessionManager.setClassLoader(this.getClassLoader());
                try {
                    towSessionManager.initialize();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            return sessionManager;
        });
    }

    public void setInitParams(Map<String, String> initParams) {
        if (initParams != null) {
            for (Map.Entry<String, String> entry : initParams.entrySet()) {
                this.addInitParameter(entry.getKey(), entry.getValue());
            }
        }
    }

    public void setListeners(TowListener[] towListeners) {
        if (towListeners != null) {
            for (TowListener towListener : towListeners) {
                this.addListener(towListener);
            }
        }
    }

    public void setServlets(TowServlet[] towServlets) {
        if (towServlets != null) {
            for (TowServlet towServlet : towServlets) {
                ServletInfo existingServlet = (ServletInfo)this.getServlets().get(towServlet.getName());
                if (this.getServlets().containsKey(towServlet.getName())) {
                    throw new IllegalArgumentException("Duplicate servlet name detected: Existing: " + String.valueOf(existingServlet) + "; This: " + String.valueOf((Object)towServlet) + "; Each servlet added to the servlet context must have a unique name. Otherwise existing servlets will be ignored.");
                }
                this.addServlet(towServlet);
            }
        }
    }

    public void setFilters(TowFilter[] towFilters) {
        if (towFilters != null) {
            for (TowFilter towFilter : towFilters) {
                this.addFilter(towFilter);
                if (towFilter.getUrlMappings() != null) {
                    for (FilterMappingInfo filterMappingInfo : towFilter.getUrlMappings()) {
                        this.addFilterUrlMapping(filterMappingInfo.getFilterName(), filterMappingInfo.getMapping(), filterMappingInfo.getDispatcher());
                    }
                }
                if (towFilter.getServletMappings() == null) continue;
                for (FilterMappingInfo filterMappingInfo : towFilter.getServletMappings()) {
                    this.addFilterServletNameMapping(filterMappingInfo.getFilterName(), filterMappingInfo.getMapping(), filterMappingInfo.getDispatcher());
                }
            }
        }
    }

    public void setServletContainerInitializers(ServletContainerInitializer[] servletContainerInitializers) {
        Assert.notNull((Object)servletContainerInitializers, "servletContainerInitializers must not be null");
        for (ServletContainerInitializer initializer : servletContainerInitializers) {
            Class servletContainerInitializerClass = initializer.getClass();
            ImmediateInstanceFactory instanceFactory = new ImmediateInstanceFactory((Object)initializer);
            ServletContainerInitializerInfo sciInfo = new ServletContainerInitializerInfo(servletContainerInitializerClass, (InstanceFactory)instanceFactory, NO_CLASSES);
            this.addServletContainerInitializer(sciInfo);
        }
    }

    public void setWebSocketInitializer(TowWebSocketInitializer webSocketInitializer) {
        if (webSocketInitializer != null) {
            webSocketInitializer.initialize(this);
        }
    }

    public void setWelcomePages(String[] welcomePages) {
        if (welcomePages != null) {
            this.addWelcomePages(welcomePages);
        }
    }

    public void setErrorPages(TowErrorPage[] errorPages) {
        if (errorPages != null) {
            this.addErrorPages(errorPages);
        }
    }

    public void setInitialHandlerChainWrappers(HandlerWrapper[] wrappers) {
        if (wrappers != null) {
            for (HandlerWrapper wrapper : wrappers) {
                this.addInitialHandlerChainWrapper(wrapper);
            }
        }
    }

    public void setInnerHandlerChainWrappers(HandlerWrapper[] wrappers) {
        if (wrappers != null) {
            for (HandlerWrapper wrapper : wrappers) {
                this.addInnerHandlerChainWrapper(wrapper);
            }
        }
    }

    public void setOuterHandlerChainWrappers(HandlerWrapper[] wrappers) {
        if (wrappers != null) {
            for (HandlerWrapper wrapper : wrappers) {
                this.addOuterHandlerChainWrapper(wrapper);
            }
        }
    }

    void createRootWebService(ServletContext servletContext) throws Exception {
        CoreService masterService = this.getActivityContext().getMasterService();
        DefaultWebService rootWebService = DefaultWebServiceBuilder.build(servletContext, masterService);
        if (rootWebService.isOrphan()) {
            rootWebService.getServiceLifeCycle().start();
        }
    }
}

