/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.session;

import com.aspectran.core.component.bean.ablility.DisposableBean;
import com.aspectran.core.component.bean.aware.ActivityContextAware;
import com.aspectran.core.component.session.DefaultSessionManager;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionStore;
import com.aspectran.core.context.ActivityContext;
import com.aspectran.core.context.config.SessionManagerConfig;
import com.aspectran.utils.apon.AponParseException;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractSessionManager
implements ActivityContextAware,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSessionManager.class);
    private final DefaultSessionManager sessionManager = new DefaultSessionManager();
    private final AtomicInteger startCount = new AtomicInteger();

    @Override
    public void setActivityContext(ActivityContext context) {
        this.sessionManager.setActivityContext(context);
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.sessionManager.setClassLoader(classLoader);
    }

    public SessionManagerConfig getSessionManagerConfig() {
        return this.sessionManager.getSessionManagerConfig();
    }

    public void setSessionManagerConfig(SessionManagerConfig sessionManagerConfig) {
        this.sessionManager.setSessionManagerConfig(sessionManagerConfig);
    }

    public void setSessionManagerConfigWithApon(String apon) {
        SessionManagerConfig sessionManagerConfig = new SessionManagerConfig();
        try {
            sessionManagerConfig.readFrom(apon);
        }
        catch (AponParseException e) {
            throw new RuntimeException(e);
        }
        this.setSessionManagerConfig(sessionManagerConfig);
    }

    public void setSessionStore(SessionStore sessionStore) {
        this.sessionManager.setSessionStore(sessionStore);
    }

    public SessionHandler getSessionHandler() {
        return this.sessionManager.getSessionHandler();
    }

    protected DefaultSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void initialize() throws Exception {
        if (this.sessionManager.isInitializable()) {
            this.sessionManager.initialize();
        }
    }

    public void start() {
        this.startCount.getAndIncrement();
    }

    public void stop() {
        int count = this.startCount.decrementAndGet();
        if (count == 0) {
            try {
                this.destroy();
            }
            catch (Exception e) {
                logger.error(e);
            }
        }
    }

    @Override
    public void destroy() throws Exception {
        if (this.sessionManager.isAvailable()) {
            try {
                this.sessionManager.destroy();
            }
            catch (Exception e) {
                throw new RuntimeException("Error destroying TowSessionManager", e);
            }
        }
    }
}

