/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.session;

import com.aspectran.core.component.session.NonPersistentValue;
import com.aspectran.undertow.server.session.TowSessionManager;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionManager;
import java.util.Set;

public final class TowSession
implements Session {
    private final TowSessionManager sessionManager;
    private final com.aspectran.core.component.session.Session session;

    TowSession(TowSessionManager sessionManager, com.aspectran.core.component.session.Session session) {
        this.sessionManager = sessionManager;
        this.session = session;
    }

    public String getId() {
        return this.session.getId();
    }

    void requestStarted(@NonNull HttpServerExchange exchange) {
        if (this.sessionManager.checkFirstAccess(exchange)) {
            this.session.access();
        }
    }

    public void requestDone(@NonNull HttpServerExchange exchange) {
        if (this.sessionManager.hasBeenAccessed(exchange)) {
            this.session.complete();
        }
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public void setMaxInactiveInterval(int interval) {
        this.session.setMaxInactiveInterval(interval);
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public Object getAttribute(String name) {
        return this.session.getAttribute(name);
    }

    public Set<String> getAttributeNames() {
        return this.session.getAttributeNames();
    }

    public Object setAttribute(String name, Object value) {
        Assert.notNull((Object)name, "name must not be null");
        if (this.isNonPersistent(name)) {
            return this.session.setAttribute(name, NonPersistentValue.wrap(value));
        }
        return this.session.setAttribute(name, value);
    }

    public Object removeAttribute(String name) {
        return this.session.removeAttribute(name);
    }

    public void invalidate(HttpServerExchange exchange) {
        this.session.invalidate();
        if (exchange != null) {
            this.sessionManager.clearSession(exchange, this.session.getId());
        }
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String changeSessionId(HttpServerExchange exchange, SessionConfig config) {
        com.aspectran.core.component.session.Session session = this.session;
        synchronized (session) {
            if (!this.session.isValid()) {
                return null;
            }
            String oldId = this.session.getId();
            String newId = this.sessionManager.getSessionHandler().createSessionId(this.hashCode());
            String newIdToUse = this.sessionManager.getSessionHandler().renewSessionId(oldId, newId);
            if (newIdToUse != null) {
                config.setSessionId(exchange, newIdToUse);
            }
            return newIdToUse;
        }
    }

    private boolean isNonPersistent(@NonNull String name) {
        return name.startsWith("io.undertow.");
    }
}

