/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.session;

import com.aspectran.core.component.session.Session;
import com.aspectran.undertow.server.session.TowSessionManager;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.Session;
import io.undertow.server.session.SessionListener;
import io.undertow.servlet.handlers.ServletRequestContext;

public final class TowSessionListener
implements com.aspectran.core.component.session.SessionListener {
    private final TowSessionManager towSessionManager;
    private final SessionListener listener;

    TowSessionListener(TowSessionManager towSessionManager, SessionListener listener) {
        this.towSessionManager = towSessionManager;
        this.listener = listener;
    }

    @Override
    public void sessionCreated(com.aspectran.core.component.session.Session session) {
        this.listener.sessionCreated((Session)this.towSessionManager.wrapSession(session), TowSessionListener.getCurrentExchange());
    }

    @Override
    public void sessionDestroyed(@NonNull com.aspectran.core.component.session.Session session) {
        SessionListener.SessionDestroyedReason reason = null;
        if (session.getDestroyedReason() != null) {
            reason = switch (session.getDestroyedReason()) {
                default -> throw new IncompatibleClassChangeError();
                case Session.DestroyedReason.INVALIDATED -> SessionListener.SessionDestroyedReason.INVALIDATED;
                case Session.DestroyedReason.TIMEOUT -> SessionListener.SessionDestroyedReason.TIMEOUT;
                case Session.DestroyedReason.UNDEPLOY -> SessionListener.SessionDestroyedReason.UNDEPLOY;
            };
        }
        this.listener.sessionDestroyed((Session)this.towSessionManager.wrapSession(session), TowSessionListener.getCurrentExchange(), reason);
    }

    @Override
    public void attributeAdded(com.aspectran.core.component.session.Session session, String name, Object value) {
        this.listener.attributeAdded((Session)this.towSessionManager.wrapSession(session), name, value);
    }

    @Override
    public void attributeUpdated(com.aspectran.core.component.session.Session session, String name, Object newValue, Object oldValue) {
        this.listener.attributeUpdated((Session)this.towSessionManager.wrapSession(session), name, newValue, oldValue);
    }

    @Override
    public void attributeRemoved(com.aspectran.core.component.session.Session session, String name, Object oldValue) {
        this.listener.attributeRemoved((Session)this.towSessionManager.wrapSession(session), name, oldValue);
    }

    @Override
    public void sessionIdChanged(com.aspectran.core.component.session.Session session, String oldSessionId) {
        this.listener.sessionIdChanged((Session)this.towSessionManager.wrapSession(session), oldSessionId);
    }

    @Nullable
    static HttpServerExchange getCurrentExchange() {
        ServletRequestContext current = ServletRequestContext.current();
        return current != null ? current.getExchange() : null;
    }
}

