/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.server.session;

import com.aspectran.core.component.session.ManagedSession;
import com.aspectran.core.component.session.Session;
import com.aspectran.undertow.server.session.AbstractSessionManager;
import com.aspectran.undertow.server.session.TowSession;
import com.aspectran.undertow.server.session.TowSessionListener;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.session.SessionConfig;
import io.undertow.server.session.SessionListener;
import io.undertow.server.session.SessionManager;
import io.undertow.server.session.SessionManagerStatistics;
import io.undertow.util.AttachmentKey;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class TowSessionManager
extends AbstractSessionManager
implements SessionManager {
    private static final Logger logger = LoggerFactory.getLogger(TowSessionManager.class);
    protected final AttachmentKey<TowSession> NEW_SESSION = AttachmentKey.create(TowSession.class);
    protected final AttachmentKey<Boolean> FIRST_ACCESS = AttachmentKey.create(Boolean.class);
    private final Map<SessionListener, TowSessionListener> sessionListenerMappings = new ConcurrentHashMap<SessionListener, TowSessionListener>();
    private int defaultSessionTimeout = Integer.MIN_VALUE;

    public String getDeploymentName() {
        return this.getSessionManager().getWorkerName();
    }

    public TowSession createSession(@NonNull HttpServerExchange exchange, @NonNull SessionConfig sessionConfig) {
        String sessionId;
        try {
            sessionId = sessionConfig.findSessionId(exchange);
        }
        catch (Exception e) {
            logger.error("Unable to create new session due to failure to find session ID", e);
            return null;
        }
        if (sessionId == null) {
            sessionId = this.getSessionManager().createSessionId(this.hashCode());
        }
        sessionConfig.setSessionId(exchange, sessionId);
        ManagedSession session = this.getSessionManager().createSession(sessionId);
        TowSession towSession = this.wrapSession(session);
        exchange.putAttachment(this.NEW_SESSION, (Object)towSession);
        return towSession;
    }

    public TowSession getSession(@NonNull HttpServerExchange exchange, SessionConfig sessionConfig) {
        String sessionId;
        TowSession newSession = (TowSession)exchange.getAttachment(this.NEW_SESSION);
        if (newSession != null) {
            return newSession;
        }
        if (sessionConfig == null) {
            throw new IllegalStateException("Could not find session config in the request");
        }
        try {
            sessionId = sessionConfig.findSessionId(exchange);
        }
        catch (Exception e) {
            logger.error("Unable to retrieve session due to failure to find session ID", e);
            return null;
        }
        TowSession towSession = this.getSession(sessionId);
        if (towSession != null) {
            towSession.requestStarted(exchange);
        }
        return towSession;
    }

    public TowSession getSession(String sessionId) {
        if (sessionId == null) {
            return null;
        }
        ManagedSession session = this.getSessionManager().getSession(sessionId);
        if (session != null) {
            return this.wrapSession(session);
        }
        return null;
    }

    public void registerSessionListener(SessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        TowSessionListener towSessionListener = new TowSessionListener(this, listener);
        this.sessionListenerMappings.put(listener, towSessionListener);
        this.getSessionManager().addSessionListener(towSessionListener);
    }

    public void removeSessionListener(SessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        TowSessionListener towSessionListener = this.sessionListenerMappings.remove(listener);
        if (towSessionListener != null) {
            this.getSessionManager().removeSessionListener(towSessionListener);
        }
    }

    public void setDefaultSessionTimeout(int timeout) {
        if (this.defaultSessionTimeout == Integer.MIN_VALUE && this.getSessionManagerConfig() != null && this.getSessionManagerConfig().hasMaxIdleSeconds()) {
            this.defaultSessionTimeout = this.getSessionManagerConfig().getMaxIdleSeconds();
        } else {
            this.defaultSessionTimeout = timeout;
            this.getSessionManager().setDefaultMaxIdleSecs(timeout);
        }
    }

    public Set<String> getTransientSessions() {
        return Collections.emptySet();
    }

    public Set<String> getActiveSessions() {
        return this.getSessionHandler().getActiveSessions();
    }

    public Set<String> getAllSessions() {
        return this.getSessionHandler().getAllSessions();
    }

    public SessionManagerStatistics getStatistics() {
        return new SessionManagerStatistics(){

            public long getCreatedSessionCount() {
                return TowSessionManager.this.getSessionManager().getStatistics().getNumberOfCreated();
            }

            public long getMaxActiveSessions() {
                return TowSessionManager.this.getSessionManager().getSessionCache().getMaxActiveSessions();
            }

            public long getHighestSessionCount() {
                return TowSessionManager.this.getSessionManager().getStatistics().getHighestNumberOfActives();
            }

            public long getActiveSessionCount() {
                return TowSessionManager.this.getSessionManager().getStatistics().getNumberOfActives();
            }

            public long getExpiredSessionCount() {
                return TowSessionManager.this.getSessionManager().getStatistics().getNumberOfExpired();
            }

            public long getRejectedSessions() {
                return TowSessionManager.this.getSessionManager().getStatistics().getNumberOfRejected();
            }

            public long getMaxSessionAliveTime() {
                return TowSessionManager.this.getSessionManager().getStatistics().getMaxSessionAliveTime();
            }

            public long getAverageSessionAliveTime() {
                return TowSessionManager.this.getSessionManager().getStatistics().getAverageSessionAliveTime();
            }

            public long getStartTime() {
                return TowSessionManager.this.getSessionManager().getStatistics().getStartTime();
            }
        };
    }

    TowSession wrapSession(@NonNull Session session) {
        return new TowSession(this, session);
    }

    void clearSession(HttpServerExchange exchange, String sessionId) {
        if (exchange != null) {
            SessionConfig sessionConfig = (SessionConfig)exchange.getAttachment(SessionConfig.ATTACHMENT_KEY);
            if (sessionConfig != null) {
                sessionConfig.clearSession(exchange, sessionId);
            }
            exchange.removeAttachment(this.NEW_SESSION);
        }
    }

    boolean checkFirstAccess(@NonNull HttpServerExchange exchange) {
        if (exchange.getAttachment(this.FIRST_ACCESS) == null) {
            exchange.putAttachment(this.FIRST_ACCESS, (Object)true);
            return true;
        }
        return false;
    }

    boolean hasBeenAccessed(@NonNull HttpServerExchange exchange) {
        return exchange.getAttachment(this.FIRST_ACCESS) != null || exchange.getAttachment(this.NEW_SESSION) != null;
    }
}

