/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.service;

import com.aspectran.core.context.config.AcceptableConfig;
import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.WebConfig;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.DefaultCoreService;
import com.aspectran.core.service.RequestAcceptor;
import com.aspectran.undertow.service.TowService;
import com.aspectran.utils.annotation.jsr305.NonNull;

public abstract class AbstractTowService
extends DefaultCoreService
implements TowService {
    private String uriDecoding;
    private boolean trailingSlashRedirect;

    AbstractTowService(CoreService parentService, boolean derived) {
        super(parentService, derived);
    }

    public String getUriDecoding() {
        return this.uriDecoding;
    }

    protected void setUriDecoding(String uriDecoding) {
        this.uriDecoding = uriDecoding;
    }

    public boolean isTrailingSlashRedirect() {
        return this.trailingSlashRedirect;
    }

    protected void setTrailingSlashRedirect(boolean trailingSlashRedirect) {
        this.trailingSlashRedirect = trailingSlashRedirect;
    }

    @Override
    protected void configure(@NonNull AspectranConfig aspectranConfig) {
        WebConfig webConfig = aspectranConfig.getWebConfig();
        if (webConfig != null) {
            this.configure(webConfig);
        }
        super.configure(aspectranConfig);
    }

    protected void configure(@NonNull WebConfig webConfig) {
        this.setUriDecoding(webConfig.getUriDecoding());
        this.setTrailingSlashRedirect(webConfig.isTrailingSlashRedirect());
        AcceptableConfig acceptableConfig = webConfig.getAcceptableConfig();
        if (acceptableConfig != null) {
            this.setRequestAcceptor(new RequestAcceptor(acceptableConfig));
        }
    }
}

