/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.service;

import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.activity.request.RequestMethodNotAllowedException;
import com.aspectran.core.activity.request.SizeLimitExceededException;
import com.aspectran.core.component.session.MaxSessionsExceededException;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.core.service.CoreService;
import com.aspectran.undertow.activity.TowActivity;
import com.aspectran.undertow.service.AbstractTowService;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.web.support.http.HttpStatus;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.Headers;
import java.io.IOException;
import java.net.URLDecoder;

public class DefaultTowService
extends AbstractTowService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTowService.class);
    protected volatile long pauseTimeout = -2L;

    DefaultTowService(CoreService parentService, boolean derived) {
        super(parentService, derived);
    }

    @Override
    public boolean service(@NonNull HttpServerExchange exchange) throws IOException {
        if (this.checkPaused(exchange)) {
            return false;
        }
        String requestName = this.getUriDecoding() != null ? URLDecoder.decode(exchange.getRequestURI(), this.getUriDecoding()) : exchange.getRequestURI();
        MethodType requestMethod = MethodType.resolve(exchange.getRequestMethod().toString(), MethodType.GET);
        if (logger.isDebugEnabled()) {
            logger.debug(this.getRequestInfo(exchange, requestName, requestMethod));
        }
        if (!this.isAcceptable(requestName)) {
            this.sendError(exchange, HttpStatus.NOT_FOUND, "Not Exposed");
            return false;
        }
        TowActivity activity = new TowActivity(this, exchange);
        activity.setRequestName(requestName);
        activity.setRequestMethod(requestMethod);
        try {
            activity.prepare();
        }
        catch (TransletNotFoundException e) {
            this.transletNotFound(activity);
            return false;
        }
        catch (Exception e) {
            this.sendError(activity, e);
            return false;
        }
        this.perform(activity);
        return true;
    }

    private void perform(TowActivity activity) {
        try {
            activity.perform();
        }
        catch (ActivityTerminatedException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Activity terminated: " + e.getMessage());
            }
        }
        catch (Exception e) {
            this.sendError(activity, e);
        }
    }

    private void transletNotFound(TowActivity activity) {
        if (this.isTrailingSlashRedirect() && activity.getRequestMethod() == MethodType.GET && StringUtils.startsWith(activity.getRequestName(), '/') && !StringUtils.endsWith(activity.getRequestName(), '/')) {
            String requestNameWithTrailingSlash = activity.getRequestName() + "/";
            if (this.getActivityContext().getTransletRuleRegistry().contains(requestNameWithTrailingSlash, activity.getRequestMethod())) {
                activity.getExchange().getResponseHeaders().put(Headers.LOCATION, requestNameWithTrailingSlash);
                activity.getExchange().getResponseHeaders().put(Headers.CONNECTION, "close");
                this.sendError(activity.getExchange(), HttpStatus.MOVED_PERMANENTLY, null);
                return;
            }
        }
        if (logger.isTraceEnabled()) {
            logger.trace("No translet mapped for " + activity.getFullRequestName());
        }
        this.sendError(activity.getExchange(), HttpStatus.NOT_FOUND, null);
    }

    private void sendError(@NonNull TowActivity activity, Exception e) {
        Throwable t = activity.getRaisedException() != null ? activity.getRaisedException() : e;
        Throwable cause = ExceptionUtils.getRootCause(t);
        logger.error("Error occurred while processing request: " + activity.getFullRequestName(), t);
        if (!activity.getExchange().isComplete()) {
            if (cause instanceof RequestMethodNotAllowedException) {
                this.sendError(activity.getExchange(), HttpStatus.METHOD_NOT_ALLOWED, null);
            } else if (cause instanceof SizeLimitExceededException) {
                this.sendError(activity.getExchange(), HttpStatus.PAYLOAD_TOO_LARGE, null);
            } else if (cause instanceof MaxSessionsExceededException) {
                this.sendError(activity.getExchange(), HttpStatus.SERVICE_UNAVAILABLE, "Max Sessions Exceeded");
            } else {
                this.sendError(activity.getExchange(), HttpStatus.INTERNAL_SERVER_ERROR, null);
            }
        }
    }

    private void sendError(@NonNull HttpServerExchange exchange, @NonNull HttpStatus status, String msg) {
        if (logger.isDebugEnabled()) {
            ToStringBuilder tsb = new ToStringBuilder("Response");
            tsb.append("code", status.value());
            tsb.append("message", msg);
            logger.debug(tsb.toString());
        }
        exchange.setStatusCode(status.value());
        if (msg != null) {
            exchange.setReasonPhrase(msg);
        }
    }

    @NonNull
    private String getRequestInfo(@NonNull HttpServerExchange exchange, String requestName, MethodType requestMethod) {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)requestMethod).append(" ");
        sb.append(requestName).append(" ");
        sb.append(exchange.getProtocol()).append(" ");
        String remoteAddr = exchange.getRequestHeaders().getFirst("X-Forwarded-For");
        if (StringUtils.hasLength(remoteAddr)) {
            sb.append(remoteAddr);
        } else {
            sb.append(exchange.getSourceAddress());
        }
        return sb.toString();
    }

    private boolean checkPaused(@NonNull HttpServerExchange exchange) {
        if (this.pauseTimeout != 0L) {
            if (this.pauseTimeout == -1L || this.pauseTimeout >= System.currentTimeMillis()) {
                if (logger.isDebugEnabled()) {
                    logger.debug(this.getServiceName() + " is paused, so did not respond to requests");
                }
                this.sendError(exchange, HttpStatus.SERVICE_UNAVAILABLE, "Paused");
                return true;
            }
            if (this.pauseTimeout == -2L) {
                logger.warn(this.getServiceName() + " is not yet started");
                this.sendError(exchange, HttpStatus.SERVICE_UNAVAILABLE, "Starting... Try again in a moment.");
                return true;
            }
            this.pauseTimeout = 0L;
        }
        return false;
    }
}

