/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.service;

import com.aspectran.core.context.config.AspectranConfig;
import com.aspectran.core.context.config.WebConfig;
import com.aspectran.core.service.CoreService;
import com.aspectran.core.service.ServiceStateListener;
import com.aspectran.undertow.service.DefaultTowService;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;

public class DefaultTowServiceBuilder {
    private static final Logger logger = LoggerFactory.getLogger(DefaultTowServiceBuilder.class);

    @NonNull
    public static DefaultTowService build(CoreService parentService) {
        WebConfig webConfig;
        Assert.notNull((Object)parentService, "parentService must not be null");
        DefaultTowService towService = new DefaultTowService(parentService, true);
        AspectranConfig aspectranConfig = parentService.getAspectranConfig();
        if (aspectranConfig != null && (webConfig = aspectranConfig.getWebConfig()) != null) {
            towService.configure(webConfig);
        }
        DefaultTowServiceBuilder.setServiceStateListener(towService);
        return towService;
    }

    @NonNull
    public static DefaultTowService build(CoreService parentService, AspectranConfig aspectranConfig) {
        Assert.notNull((Object)aspectranConfig, "aspectranConfig must not be null");
        DefaultTowService towService = new DefaultTowService(parentService, false);
        towService.configure(aspectranConfig);
        DefaultTowServiceBuilder.setServiceStateListener(towService);
        return towService;
    }

    private static void setServiceStateListener(final @NonNull DefaultTowService towService) {
        towService.setServiceStateListener(new ServiceStateListener(){

            @Override
            public void started() {
                towService.pauseTimeout = 0L;
            }

            @Override
            public void stopped() {
            }

            @Override
            public void paused(long millis) {
                if (millis > 0L) {
                    towService.pauseTimeout = System.currentTimeMillis() + millis;
                } else {
                    logger.warn("Pause timeout in milliseconds needs to be set to a value of greater than 0");
                }
            }

            @Override
            public void paused() {
                towService.pauseTimeout = -1L;
            }

            @Override
            public void resumed() {
                towService.pauseTimeout = 0L;
            }
        });
    }
}

