/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.shell.command;

import com.aspectran.core.component.bean.BeanException;
import com.aspectran.core.component.bean.BeanRegistry;
import com.aspectran.shell.command.AbstractCommand;
import com.aspectran.shell.command.Command;
import com.aspectran.shell.command.CommandRegistry;
import com.aspectran.shell.command.option.Arguments;
import com.aspectran.shell.command.option.Option;
import com.aspectran.shell.command.option.ParsedOptions;
import com.aspectran.shell.console.ShellConsole;
import com.aspectran.undertow.server.TowServer;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.net.BindException;

public class UndertowCommand
extends AbstractCommand {
    private static final String NAMESPACE = "builtins";
    private static final String COMMAND_NAME = "undertow";
    private final CommandDescriptor descriptor = new CommandDescriptor();

    public UndertowCommand(CommandRegistry registry) {
        super(registry);
        this.addOption(Option.builder("server").valueName("name").withEqualSign().desc("ID of bean that defined Undertow server").build());
        this.addOption(Option.builder("h").longName("help").desc("Display help for this command").build());
        Arguments arguments = this.touchArguments();
        arguments.setTitle("Available commands:");
        arguments.put("start", "Start Undertow server");
        arguments.put("stop", "Stop Undertow server");
        arguments.put("restart", "Restart Undertow server");
        arguments.put("status", "Display a brief status report");
        arguments.setRequired(true);
    }

    @Override
    public void execute(@NonNull ParsedOptions options, ShellConsole console) throws Exception {
        block17: {
            block16: {
                if (!options.hasOptions() && !options.hasArgs()) {
                    this.printQuickHelp(console);
                    return;
                }
                if (options.hasOption("help")) {
                    this.printHelp(console);
                    return;
                }
                String command = null;
                if (options.hasArgs()) {
                    command = options.getFirstArg();
                }
                String serverName = options.getValue("server", "tow.server");
                if (command == null) break block16;
                switch (command) {
                    case "start": {
                        this.startTowServer(serverName, console);
                        break;
                    }
                    case "stop": {
                        this.stopTowServer(serverName, console);
                        break;
                    }
                    case "restart": {
                        if (this.stopTowServer(serverName, console)) {
                            this.startTowServer(serverName, console);
                            break;
                        }
                        break block17;
                    }
                    case "status": {
                        this.printServerStatus(serverName, console);
                        break;
                    }
                    default: {
                        console.writeError("Unknown command '" + String.join((CharSequence)" ", options.getArgs()) + "'");
                        this.printQuickHelp(console);
                        break;
                    }
                }
                break block17;
            }
            this.printQuickHelp(console);
        }
    }

    private void startTowServer(String serverName, ShellConsole console) throws Exception {
        TowServer towServer = null;
        try {
            if (this.hasTowServer(serverName)) {
                towServer = this.getTowServer(serverName);
                if (towServer.isRunning()) {
                    console.writeError("Undertow server is already running");
                } else {
                    towServer.start();
                    this.printStatus(towServer.getState(), console);
                }
            } else {
                towServer = this.getTowServer(serverName);
                if (!towServer.isRunning()) {
                    towServer.start();
                }
                this.printStatus(towServer.getState(), console);
            }
        }
        catch (BeanException e) {
            console.writeError("Undertow server is not available. Cause: " + String.valueOf(e));
        }
        catch (Exception e) {
            Throwable cause;
            if (towServer != null) {
                this.destroyTowServer(towServer);
            }
            if ((cause = ExceptionUtils.getRootCause(e)) instanceof BindException) {
                console.writeError("Undertow server failed to start. Cause: Port already in use");
            }
            console.writeError(e.toString());
        }
    }

    private boolean stopTowServer(String serverName, ShellConsole console) {
        boolean success = false;
        try {
            if (this.hasTowServer(serverName)) {
                TowServer towServer = this.getTowServer(serverName);
                this.destroyTowServer(towServer);
                this.printStatus("STOPPED", console);
                success = true;
            } else {
                console.writeError("Undertow server is not running");
            }
        }
        catch (BeanException e) {
            console.writeError("Undertow server is not available. Cause: " + String.valueOf(e));
        }
        catch (Exception e) {
            console.writeError(e.toString());
        }
        return success;
    }

    private void printServerStatus(String serverName, ShellConsole console) {
        try {
            if (this.hasTowServer(serverName)) {
                TowServer towServer = this.getTowServer(serverName);
                if (towServer.isStarted()) {
                    this.printStatus("RUNNING", console);
                } else {
                    this.printStatus(towServer.getState(), console);
                }
            } else {
                this.printStatus("STOPPED", console);
            }
        }
        catch (BeanException e) {
            console.writeError("Undertow server is not available. Cause: " + String.valueOf(e));
        }
        catch (Exception e) {
            console.writeError(e.toString());
        }
    }

    private void printStatus(String status, @NonNull ShellConsole console) {
        console.writeLine("----------------------------------------------------------------------------");
        console.setStyle("YELLOW");
        console.write(status);
        console.resetStyle();
        console.writeLine(" - Undertow " + TowServer.getVersion());
        console.writeLine("----------------------------------------------------------------------------");
    }

    private TowServer getTowServer(String serverName) {
        BeanRegistry beanRegistry = this.getActiveShellService().getActivityContext().getBeanRegistry();
        return beanRegistry.getBean(TowServer.class, serverName);
    }

    private boolean hasTowServer(String serverName) {
        BeanRegistry beanRegistry = this.getActiveShellService().getActivityContext().getBeanRegistry();
        return beanRegistry.hasSingleton(TowServer.class, serverName);
    }

    private void destroyTowServer(TowServer towServer) throws Exception {
        BeanRegistry beanRegistry = this.getActiveShellService().getActivityContext().getBeanRegistry();
        beanRegistry.destroySingleton(towServer);
    }

    @Override
    public Command.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class CommandDescriptor
    implements Command.Descriptor {
        private CommandDescriptor() {
        }

        @Override
        public String getNamespace() {
            return UndertowCommand.NAMESPACE;
        }

        @Override
        public String getName() {
            return UndertowCommand.COMMAND_NAME;
        }

        @Override
        @NonNull
        public String getDescription() {
            return "Use the command 'undertow' to control the Undertow server";
        }

        @Override
        @Nullable
        public String getUsage() {
            return null;
        }
    }
}

