/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.undertow.support;

import com.aspectran.core.activity.InstantActivitySupport;
import com.aspectran.core.component.session.SessionHandler;
import com.aspectran.core.component.session.SessionListener;
import com.aspectran.core.component.session.SessionListenerRegistration;
import com.aspectran.undertow.server.TowServer;
import com.aspectran.utils.Assert;
import com.aspectran.utils.annotation.jsr305.NonNull;

public class SessionListenerRegistrationBean
extends InstantActivitySupport
implements SessionListenerRegistration {
    private final String towServerId;
    private final String deploymentName;

    public SessionListenerRegistrationBean(String towServerId, String deploymentName) {
        this.towServerId = towServerId;
        this.deploymentName = deploymentName;
    }

    @Override
    public void register(SessionListener listener) {
        Assert.notNull((Object)listener, "listener must not be null");
        this.getSessionHandler().addSessionListener(listener);
    }

    @Override
    public void register(SessionListener listener, String deploymentName) {
        Assert.notNull((Object)listener, "listener must not be null");
        Assert.notNull((Object)deploymentName, "deploymentName must not be null");
        this.getSessionHandler(deploymentName).addSessionListener(listener);
    }

    @Override
    public void remove(SessionListener listener) {
        Assert.notNull((Object)listener, "listener must not be null");
        if (this.getBeanRegistry().isAvailable()) {
            this.getSessionHandler().removeSessionListener(listener);
        }
    }

    @Override
    public void remove(SessionListener listener, String deploymentName) {
        Assert.notNull((Object)listener, "listener must not be null");
        Assert.notNull((Object)deploymentName, "deploymentName must not be null");
        if (this.getBeanRegistry().isAvailable()) {
            this.getSessionHandler(deploymentName).removeSessionListener(listener);
        }
    }

    @NonNull
    private SessionHandler getSessionHandler() {
        SessionHandler sessionHandler = this.getTowServer().getSessionHandler(this.deploymentName);
        if (sessionHandler == null) {
            throw new IllegalStateException("No session handler found for deployment: " + this.deploymentName);
        }
        return sessionHandler;
    }

    @NonNull
    private SessionHandler getSessionHandler(String deploymentName) {
        Assert.notNull((Object)deploymentName, "deploymentName must not be null");
        SessionHandler sessionHandler = this.getTowServer().getSessionHandler(deploymentName);
        if (sessionHandler == null) {
            throw new IllegalStateException("No session handler found for deployment: " + deploymentName);
        }
        return sessionHandler;
    }

    @NonNull
    private TowServer getTowServer() {
        TowServer towServer = (TowServer)this.getBeanRegistry().getBean(this.towServerId);
        if (towServer == null) {
            throw new IllegalStateException("No TowServer named '" + this.towServerId + "'");
        }
        return towServer;
    }
}

