/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.BeanDescriptor;
import com.aspectran.utils.ClassUtils;
import com.aspectran.utils.MethodUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class BeanUtils {
    private static final Object[] NO_ARGUMENTS = new Object[0];

    public static Object getProperty(Class<?> beanClass, String name) throws InvocationTargetException {
        try {
            BeanDescriptor bd = BeanUtils.getBeanDescriptor(beanClass);
            Method method = bd.getGetter(name);
            Object bean = null;
            if (!Modifier.isStatic(method.getModifiers())) {
                bean = ClassUtils.createInstance(beanClass);
            }
            try {
                return method.invoke(bean, NO_ARGUMENTS);
            }
            catch (Throwable t) {
                throw BeanUtils.unwrapThrowable(t);
            }
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t, "Could not get property '" + name + "' from " + beanClass.getName() + ". Cause: " + String.valueOf(t));
        }
    }

    public static void setProperty(Class<?> beanClass, String name, Object value) throws InvocationTargetException {
        Object bean = null;
        try {
            BeanDescriptor bd = BeanUtils.getBeanDescriptor(beanClass);
            Method method = bd.getSetter(name);
            Object[] params = new Object[]{value};
            if (!Modifier.isStatic(method.getModifiers())) {
                bean = ClassUtils.createInstance(beanClass);
            }
            try {
                method.invoke(bean, params);
            }
            catch (Throwable t) {
                throw BeanUtils.unwrapThrowable(t);
            }
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Throwable t) {
            try {
                if (bean != null) {
                    MethodUtils.invokeSetter(bean, name, value);
                } else {
                    MethodUtils.invokeStaticMethod(beanClass, name, value);
                }
                return;
            }
            catch (Throwable throwable) {
                throw new InvocationTargetException(t, "Could not set property '" + name + "' to value '" + String.valueOf(value) + "' for " + beanClass.getName() + ". Cause: " + String.valueOf(t));
            }
        }
    }

    public static boolean hasReadableProperty(Class<?> beanClass, String name) {
        try {
            BeanDescriptor bd = BeanUtils.getBeanDescriptor(beanClass);
            bd.getGetter(name);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean hasWritableProperty(Class<?> beanClass, String name) {
        try {
            BeanDescriptor bd = BeanUtils.getBeanDescriptor(beanClass);
            bd.getSetter(name);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean hasStaticReadableProperty(Class<?> beanClass, String name) {
        try {
            BeanDescriptor bd = BeanUtils.getBeanDescriptor(beanClass);
            Method method = bd.getGetter(name);
            return Modifier.isStatic(method.getModifiers());
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean hasStaticWritableProperty(Class<?> beanClass, String name) {
        try {
            BeanDescriptor bd = BeanUtils.getBeanDescriptor(beanClass);
            Method method = bd.getSetter(name);
            return Modifier.isStatic(method.getModifiers());
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Object getProperty(Object bean, @NonNull String name) throws InvocationTargetException {
        if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            Object value = bean;
            while (parser.hasMoreTokens() && (value = BeanUtils.getSimpleProperty(value, parser.nextToken())) != null) {
            }
            return value;
        }
        return BeanUtils.getSimpleProperty(bean, name);
    }

    public static Object getSimpleProperty(Object bean, @NonNull String name) throws InvocationTargetException {
        try {
            Object value;
            if (name.contains("[")) {
                value = BeanUtils.getIndexedProperty(bean, name);
            } else if (bean instanceof Map) {
                Map map = (Map)bean;
                value = map.get(name);
            } else {
                BeanDescriptor bd = BeanUtils.getBeanDescriptor(bean.getClass());
                Method method = bd.getGetter(name);
                try {
                    value = method.invoke(bean, NO_ARGUMENTS);
                }
                catch (Throwable t) {
                    throw BeanUtils.unwrapThrowable(t);
                }
            }
            return value;
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Throwable t) {
            if (bean == null) {
                throw new InvocationTargetException(t, "Could not get property '" + name + "' from null reference. Cause: " + String.valueOf(t));
            }
            throw new InvocationTargetException(t, "Could not get property '" + name + "' from " + bean.getClass().getName() + ". Cause: " + String.valueOf(t));
        }
    }

    public static void setProperty(Object bean, @NonNull String name, Object value) throws InvocationTargetException, NoSuchMethodException {
        if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            String newName = parser.nextToken();
            Object child = bean;
            while (parser.hasMoreTokens()) {
                Class<?> type = BeanUtils.getPropertyTypeForSetter(child, newName);
                Object parent = child;
                if ((child = BeanUtils.getSimpleProperty(parent, newName)) == null) {
                    if (value == null) {
                        return;
                    }
                    try {
                        child = ClassUtils.createInstance(type);
                        BeanUtils.setProperty(parent, newName, child);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e, "Cannot set value of property '" + name + "' because '" + newName + "' is null and cannot be instantiated on instance of " + type.getName() + ". Cause: " + String.valueOf(e));
                    }
                }
                newName = parser.nextToken();
            }
            BeanUtils.setSimpleProperty(child, newName, value);
        } else {
            BeanUtils.setSimpleProperty(bean, name, value);
        }
    }

    public static void setSimpleProperty(Object bean, @NonNull String name, Object value) throws InvocationTargetException {
        block10: {
            try {
                if (name.contains("[")) {
                    BeanUtils.setIndexedProperty(bean, name, value);
                    break block10;
                }
                if (bean instanceof Map) {
                    Map map = (Map)bean;
                    map.put(name, value);
                    break block10;
                }
                BeanDescriptor bd = BeanUtils.getBeanDescriptor(bean.getClass());
                Method method = bd.getSetter(name);
                Object[] params = new Object[]{value};
                try {
                    method.invoke(bean, params);
                }
                catch (Throwable t) {
                    throw BeanUtils.unwrapThrowable(t);
                }
            }
            catch (InvocationTargetException e) {
                throw e;
            }
            catch (Throwable t) {
                try {
                    MethodUtils.invokeSetter(bean, name, value);
                    return;
                }
                catch (Throwable throwable) {
                    if (bean == null) {
                        throw new InvocationTargetException(t, "Could not set property '" + name + "' to value '" + String.valueOf(value) + "' for null reference. Cause: " + String.valueOf(t));
                    }
                    throw new InvocationTargetException(t, "Could not set property '" + name + "' to value '" + String.valueOf(value) + "' for " + bean.getClass().getName() + ". Cause: " + String.valueOf(t));
                }
            }
        }
    }

    public static Object getIndexedProperty(Object bean, @NonNull String indexedName) throws InvocationTargetException {
        try {
            Object value;
            Object obj;
            String name = indexedName.substring(0, indexedName.indexOf("["));
            int index = Integer.parseInt(indexedName.substring(indexedName.indexOf("[") + 1, indexedName.indexOf("]")));
            Object object = obj = !name.isEmpty() ? BeanUtils.getSimpleProperty(bean, name) : bean;
            if (obj instanceof List) {
                List list = (List)obj;
                value = list.get(index);
            } else if (obj instanceof Object[]) {
                Object[] arr = (Object[])obj;
                value = arr[index];
            } else if (obj instanceof char[]) {
                char[] arr = (char[])obj;
                value = Character.valueOf(arr[index]);
            } else if (obj instanceof boolean[]) {
                boolean[] arr = (boolean[])obj;
                value = arr[index];
            } else if (obj instanceof byte[]) {
                byte[] arr = (byte[])obj;
                value = arr[index];
            } else if (obj instanceof double[]) {
                double[] arr = (double[])obj;
                value = arr[index];
            } else if (obj instanceof float[]) {
                float[] arr = (float[])obj;
                value = Float.valueOf(arr[index]);
            } else if (obj instanceof int[]) {
                int[] arr = (int[])obj;
                value = arr[index];
            } else if (obj instanceof long[]) {
                long[] arr = (long[])obj;
                value = arr[index];
            } else if (obj instanceof short[]) {
                short[] arr = (short[])obj;
                value = arr[index];
            } else {
                throw new IllegalArgumentException("The '" + name + "' property of the " + bean.getClass().getName() + " class is not a List or Array");
            }
            return value;
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, "Error getting ordinal list from JavaBean. Cause: " + String.valueOf(e));
        }
    }

    public static Class<?> getIndexedType(Object bean, @NonNull String indexedName) throws InvocationTargetException {
        try {
            Class<Object> value;
            Object obj;
            String name = indexedName.substring(0, indexedName.indexOf("["));
            int i = Integer.parseInt(indexedName.substring(indexedName.indexOf("[") + 1, indexedName.indexOf("]")));
            Object object = obj = !name.isEmpty() ? BeanUtils.getSimpleProperty(bean, name) : bean;
            if (obj instanceof List) {
                List list = (List)obj;
                value = list.get(i).getClass();
            } else if (obj instanceof Object[]) {
                Object[] arr = (Object[])obj;
                value = arr[i].getClass();
            } else if (obj instanceof char[]) {
                value = Character.class;
            } else if (obj instanceof boolean[]) {
                value = Boolean.class;
            } else if (obj instanceof byte[]) {
                value = Byte.class;
            } else if (obj instanceof double[]) {
                value = Double.class;
            } else if (obj instanceof float[]) {
                value = Float.class;
            } else if (obj instanceof int[]) {
                value = Integer.class;
            } else if (obj instanceof long[]) {
                value = Long.class;
            } else if (obj instanceof short[]) {
                value = Short.class;
            } else {
                throw new IllegalArgumentException("The '" + name + "' property of the " + bean.getClass().getName() + " class is not a List or Array");
            }
            return value;
        }
        catch (InvocationTargetException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, "Error getting ordinal list from JavaBean. Cause: " + String.valueOf(e));
        }
    }

    public static void setIndexedProperty(Object bean, @NonNull String indexedName, Object value) throws InvocationTargetException {
        block13: {
            try {
                String name = indexedName.substring(0, indexedName.indexOf("["));
                int index = Integer.parseInt(indexedName.substring(indexedName.indexOf("[") + 1, indexedName.indexOf("]")));
                Object obj = BeanUtils.getSimpleProperty(bean, name);
                if (obj instanceof List) {
                    List llist = (List)obj;
                    llist.set(index, value);
                    break block13;
                }
                if (obj instanceof Object[]) {
                    Object[] arr = (Object[])obj;
                    arr[index] = value;
                    break block13;
                }
                if (obj instanceof char[]) {
                    char[] arr = (char[])obj;
                    arr[index] = ((Character)value).charValue();
                    break block13;
                }
                if (obj instanceof boolean[]) {
                    boolean[] arr = (boolean[])obj;
                    arr[index] = (Boolean)value;
                    break block13;
                }
                if (obj instanceof byte[]) {
                    byte[] arr = (byte[])obj;
                    arr[index] = (Byte)value;
                    break block13;
                }
                if (obj instanceof double[]) {
                    double[] arr = (double[])obj;
                    arr[index] = (Double)value;
                    break block13;
                }
                if (obj instanceof float[]) {
                    float[] arr = (float[])obj;
                    arr[index] = ((Float)value).floatValue();
                    break block13;
                }
                if (obj instanceof int[]) {
                    int[] arr = (int[])obj;
                    arr[index] = (Integer)value;
                    break block13;
                }
                if (obj instanceof long[]) {
                    long[] arr = (long[])obj;
                    arr[index] = (Long)value;
                    break block13;
                }
                if (obj instanceof short[]) {
                    short[] arr = (short[])obj;
                    arr[index] = (Short)value;
                    break block13;
                }
                throw new IllegalArgumentException("The '" + name + "' property of the " + bean.getClass().getName() + " class is not a List or Array");
            }
            catch (InvocationTargetException e) {
                throw e;
            }
            catch (Exception e) {
                throw new InvocationTargetException(e, "Error getting ordinal value from JavaBean. Cause: " + String.valueOf(e));
            }
        }
    }

    public static boolean hasWritableProperty(Object bean, @NonNull String name) throws NoSuchMethodException {
        boolean exists = false;
        if (bean instanceof Map) {
            exists = true;
        } else if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            Class<?> type = bean.getClass();
            while (parser.hasMoreTokens()) {
                name = parser.nextToken();
                type = BeanUtils.getBeanDescriptor(type).getGetterType(name);
                exists = BeanUtils.getBeanDescriptor(type).hasWritableProperty(name);
            }
        } else {
            exists = BeanUtils.getBeanDescriptor(bean.getClass()).hasWritableProperty(name);
        }
        return exists;
    }

    public static boolean hasReadableProperty(Object bean, @NonNull String name) throws NoSuchMethodException {
        boolean exists = false;
        if (bean instanceof Map) {
            exists = true;
        } else if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            Class<?> type = bean.getClass();
            while (parser.hasMoreTokens()) {
                name = parser.nextToken();
                type = BeanUtils.getBeanDescriptor(type).getGetterType(name);
                exists = BeanUtils.getBeanDescriptor(type).hasReadableProperty(name);
            }
        } else {
            exists = BeanUtils.getBeanDescriptor(bean.getClass()).hasReadableProperty(name);
        }
        return exists;
    }

    private static Throwable unwrapThrowable(Throwable t) {
        Throwable t2 = t;
        while (true) {
            if (t2 instanceof InvocationTargetException) {
                InvocationTargetException e = (InvocationTargetException)t2;
                t2 = e.getTargetException();
                continue;
            }
            if (!(t2 instanceof UndeclaredThrowableException)) break;
            UndeclaredThrowableException e = (UndeclaredThrowableException)t2;
            t2 = e.getUndeclaredThrowable();
        }
        return t2;
    }

    public static Class<?> getPropertyTypeForSetter(@NonNull Object bean, String name) throws NoSuchMethodException {
        Class<Object> type = bean.getClass();
        if (bean instanceof Class) {
            type = BeanUtils.getClassPropertyTypeForSetter((Class)bean, name);
        } else if (bean instanceof Map) {
            Map map = (Map)bean;
            Object value = map.get(name);
            type = value == null ? Object.class : value.getClass();
        } else if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            while (parser.hasMoreTokens()) {
                name = parser.nextToken();
                type = BeanUtils.getBeanDescriptor(type).getSetterType(name);
            }
        } else {
            type = BeanUtils.getBeanDescriptor(type).getSetterType(name);
        }
        return type;
    }

    public static Class<?> getPropertyTypeForGetter(@NonNull Object bean, String name) throws NoSuchMethodException {
        Class<Object> type = bean.getClass();
        if (bean instanceof Class) {
            type = BeanUtils.getClassPropertyTypeForGetter((Class)bean, name);
        } else if (bean instanceof Map) {
            Map map = (Map)bean;
            Object value = map.get(name);
            type = value == null ? Object.class : value.getClass();
        } else if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            while (parser.hasMoreTokens()) {
                name = parser.nextToken();
                type = BeanUtils.getBeanDescriptor(type).getGetterType(name);
            }
        } else {
            type = BeanUtils.getBeanDescriptor(type).getGetterType(name);
        }
        return type;
    }

    public static Class<?> getClassPropertyTypeForGetter(Class<?> type, @NonNull String name) throws NoSuchMethodException {
        if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            while (parser.hasMoreTokens()) {
                name = parser.nextToken();
                type = BeanUtils.getBeanDescriptor(type).getGetterType(name);
            }
        } else {
            type = BeanUtils.getBeanDescriptor(type).getGetterType(name);
        }
        return type;
    }

    public static Class<?> getClassPropertyTypeForSetter(Class<?> type, @NonNull String name) throws NoSuchMethodException {
        if (name.contains(".")) {
            StringTokenizer parser = new StringTokenizer(name, ".");
            while (parser.hasMoreTokens()) {
                name = parser.nextToken();
                type = BeanUtils.getBeanDescriptor(type).getSetterType(name);
            }
        } else {
            type = BeanUtils.getBeanDescriptor(type).getSetterType(name);
        }
        return type;
    }

    public static String[] getReadablePropertyNames(@NonNull Object bean) {
        return BeanUtils.getBeanDescriptor(bean.getClass()).getReadablePropertyNames();
    }

    public static String[] getReadablePropertyNamesWithoutNonSerializable(@NonNull Object bean) {
        return BeanUtils.getBeanDescriptor(bean.getClass()).getReadablePropertyNamesWithoutNonSerializable();
    }

    public static String[] getWritablePropertyNames(@NonNull Object bean) {
        return BeanUtils.getBeanDescriptor(bean.getClass()).getWritablePropertyNames();
    }

    private static BeanDescriptor getBeanDescriptor(Class<?> beanClass) {
        return BeanDescriptor.getInstance(beanClass);
    }
}

