/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.Assert;
import com.aspectran.utils.ExceptionUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public abstract class ClassUtils {
    public static final char PACKAGE_SEPARATOR_CHAR = '.';
    public static final String CLASS_FILE_SUFFIX = ".class";

    @NonNull
    public static <T> T createInstance(Class<T> clazz) {
        Constructor<T> ctor;
        try {
            ctor = ClassUtils.findConstructor(clazz, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " has no default (no arg) constructor");
        }
        try {
            return ctor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw ExceptionUtils.unwrapAndThrowAsIAE(e, "Unable to instantiate class " + clazz.getName() + ": " + e.getMessage());
        }
    }

    @NonNull
    public static <T> T createInstance(Class<T> clazz, Object ... args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        return ClassUtils.createInstance(clazz, args, argTypes);
    }

    @NonNull
    public static <T> T createInstance(Class<T> clazz, Object[] args, Class<?>[] argTypes) {
        Constructor<T> ctor;
        try {
            ctor = ClassUtils.findConstructor(clazz, argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class " + clazz.getName() + " has no constructor which can accept the given arguments");
        }
        try {
            return ctor.newInstance(args);
        }
        catch (Exception e) {
            throw ExceptionUtils.unwrapAndThrowAsIAE(e, "Unable to instantiate class " + clazz.getName() + ", problem: " + e.getMessage());
        }
    }

    @NonNull
    public static <T> Constructor<T> findConstructor(Class<T> clazz, Class<?> ... argTypes) throws NoSuchMethodException {
        Constructor<T> ctor;
        Assert.notNull(clazz, "cls must not be null");
        try {
            ctor = clazz.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to find constructor of class " + clazz.getName() + ", problem: " + e.getMessage(), ExceptionUtils.getRootCause(e));
        }
        if (!Modifier.isPublic(ctor.getModifiers())) {
            throw new IllegalArgumentException("Constructor for " + clazz.getName() + " is not accessible (non-public?): not allowed to try modify access via Reflection: can not instantiate type");
        }
        return ctor;
    }

    public static boolean isVisible(Class<?> clazz, ClassLoader classLoader) {
        if (classLoader == null) {
            return true;
        }
        try {
            if (clazz.getClassLoader() == classLoader) {
                return true;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return ClassUtils.isLoadable(clazz, classLoader);
    }

    @NonNull
    private static boolean isLoadable(@NonNull Class<?> clazz, ClassLoader classLoader) {
        Assert.notNull((Object)classLoader, "classLoader must not be null");
        try {
            return clazz == classLoader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
    }

    public static boolean isLambdaClass(@NonNull Class<?> clazz) {
        return clazz.isSynthetic() && clazz.getSuperclass() == Object.class && clazz.getInterfaces().length > 0 && clazz.getName().contains("$$Lambda");
    }

    @NonNull
    public static <T> Class<T> classForName(String name) throws ClassNotFoundException {
        return ClassUtils.classForName(name, ClassUtils.getDefaultClassLoader());
    }

    @NonNull
    public static <T> Class<T> classForName(String name, ClassLoader classLoader) throws ClassNotFoundException {
        return Class.forName(name, true, classLoader);
    }

    public static <T> Class<T> loadClass(String name) throws ClassNotFoundException {
        return ClassUtils.getDefaultClassLoader().loadClass(name);
    }

    public static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null) {
            cl = ClassUtils.class.getClassLoader();
        }
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        return cl;
    }
}

