/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;

public class FileLocker {
    private static final Logger logger = LoggerFactory.getLogger(FileLocker.class);
    private static final String DEFAULT_LOCK_FILENAME = ".lock";
    private File lockFile;
    private FileChannel fileChannel;
    private FileLock fileLock;

    public FileLocker(File lockFile) {
        if (lockFile == null) {
            throw new IllegalArgumentException("lockFile must not be null");
        }
        this.lockFile = lockFile;
    }

    public FileLocker(String basePath) {
        this(basePath, DEFAULT_LOCK_FILENAME);
    }

    public FileLocker(String basePath, String filename) {
        this(new File(basePath, filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean lock() throws Exception {
        FileLocker fileLocker = this;
        synchronized (fileLocker) {
            if (this.fileLock != null) {
                throw new Exception("Lock is already held");
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Acquiring lock on " + this.lockFile.getAbsolutePath());
            }
            try {
                this.fileChannel = new RandomAccessFile(this.lockFile, "rw").getChannel();
                this.fileLock = this.fileChannel.tryLock();
            }
            catch (IOException e) {
                throw new Exception("Exception occurred while trying to get a lock on file: " + this.lockFile.getAbsolutePath(), e);
            }
            if (this.fileLock == null) {
                if (this.fileChannel != null) {
                    try {
                        this.fileChannel.close();
                    }
                    catch (IOException ie) {
                        logger.warn(ie);
                    }
                    this.fileChannel = null;
                }
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws Exception {
        FileLocker fileLocker = this;
        synchronized (fileLocker) {
            if (logger.isDebugEnabled()) {
                logger.debug("Releasing lock on " + this.lockFile.getAbsolutePath());
            }
            if (this.fileLock != null) {
                try {
                    if (this.fileLock.isValid()) {
                        this.fileLock.release();
                    } else if (logger.isDebugEnabled()) {
                        logger.debug("Lock already released: " + this.lockFile.getAbsolutePath());
                    }
                    this.fileLock = null;
                }
                catch (Exception e) {
                    throw new Exception("Unable to release locked file: " + this.lockFile.getAbsolutePath(), e);
                }
                if (this.fileChannel != null) {
                    try {
                        this.fileChannel.close();
                    }
                    catch (IOException e) {
                        logger.warn(e);
                    }
                    this.fileChannel = null;
                }
                if (this.lockFile != null) {
                    if (this.lockFile.delete()) {
                        if (logger.isTraceEnabled()) {
                            logger.trace("Deleted lock file " + this.lockFile.getAbsolutePath());
                        }
                    } else if (this.lockFile.exists() && logger.isDebugEnabled()) {
                        logger.debug("Could not delete lock file " + this.lockFile.getAbsolutePath());
                    }
                    this.lockFile = null;
                }
            }
        }
    }
}

