/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;

public abstract class ObjectUtils {
    private static final String NULL_STRING = "null";
    private static final String ARRAY_START = "[";
    private static final String ARRAY_END = "]";
    private static final String EMPTY_ARRAY = "[]";
    private static final String ARRAY_ELEMENT_SEPARATOR = ", ";
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];

    public static boolean isArray(@Nullable Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static boolean isEmpty(@Nullable Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean isEmpty(@Nullable Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Optional) {
            Optional optional = (Optional)obj;
            return optional.isEmpty();
        }
        if (obj instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)obj;
            return charSequence.isEmpty();
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof Collection) {
            Collection collection = (Collection)obj;
            return collection.isEmpty();
        }
        if (obj instanceof Map) {
            Map map = (Map)obj;
            return map.isEmpty();
        }
        return false;
    }

    public static Object[] toObjectArray(@Nullable Object source) {
        if (source instanceof Object[]) {
            return (Object[])source;
        }
        if (source == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        if (!source.getClass().isArray()) {
            throw new IllegalArgumentException("Source is not an array: " + String.valueOf(source));
        }
        int length = Array.getLength(source);
        if (length == 0) {
            return EMPTY_OBJECT_ARRAY;
        }
        Class<?> wrapperType = Array.get(source, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            newArray[i] = Array.get(source, i);
        }
        return newArray;
    }

    public static boolean nullSafeEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return ObjectUtils.arrayEquals(o1, o2);
        }
        return false;
    }

    private static boolean arrayEquals(Object o1, Object o2) {
        Object[] a1;
        if (o1 instanceof Object[]) {
            a1 = (Object[])o1;
            if (o2 instanceof Object[]) {
                Object[] a2 = (Object[])o2;
                return Arrays.equals(a1, a2);
            }
        }
        if (o1 instanceof boolean[]) {
            a1 = (boolean[])o1;
            if (o2 instanceof boolean[]) {
                boolean[] a2 = (boolean[])o2;
                return Arrays.equals((boolean[])a1, a2);
            }
        }
        if (o1 instanceof byte[]) {
            a1 = (byte[])o1;
            if (o2 instanceof byte[]) {
                byte[] a2 = (byte[])o2;
                return Arrays.equals((byte[])a1, a2);
            }
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        if (o1 instanceof double[]) {
            a1 = (double[])o1;
            if (o2 instanceof double[]) {
                double[] a2 = (double[])o2;
                return Arrays.equals((double[])a1, a2);
            }
        }
        if (o1 instanceof float[]) {
            a1 = (float[])o1;
            if (o2 instanceof float[]) {
                float[] a2 = (float[])o2;
                return Arrays.equals((float[])a1, a2);
            }
        }
        if (o1 instanceof int[]) {
            a1 = (int[])o1;
            if (o2 instanceof int[]) {
                int[] a2 = (int[])o2;
                return Arrays.equals((int[])a1, a2);
            }
        }
        if (o1 instanceof long[]) {
            a1 = (long[])o1;
            if (o2 instanceof long[]) {
                long[] a2 = (long[])o2;
                return Arrays.equals((long[])a1, a2);
            }
        }
        if (o1 instanceof short[]) {
            a1 = (short[])o1;
            if (o2 instanceof short[]) {
                short[] a2 = (short[])o2;
                return Arrays.equals((short[])a1, a2);
            }
        }
        return false;
    }

    public static int nullSafeHash(Object ... elements) {
        if (elements == null) {
            return 0;
        }
        int result = 1;
        for (Object element : elements) {
            result = 31 * result + ObjectUtils.nullSafeHashCode(element);
        }
        return result;
    }

    public static int nullSafeHashCode(@Nullable Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                Object[] arr = (Object[])obj;
                return Arrays.hashCode(arr);
            }
            if (obj instanceof boolean[]) {
                boolean[] arr = (boolean[])obj;
                return Arrays.hashCode(arr);
            }
            if (obj instanceof byte[]) {
                byte[] arr = (byte[])obj;
                return Arrays.hashCode(arr);
            }
            if (obj instanceof char[]) {
                char[] arr = (char[])obj;
                return Arrays.hashCode(arr);
            }
            if (obj instanceof double[]) {
                double[] arr = (double[])obj;
                return Arrays.hashCode(arr);
            }
            if (obj instanceof float[]) {
                float[] arr = (float[])obj;
                return Arrays.hashCode(arr);
            }
            if (obj instanceof int[]) {
                int[] arr = (int[])obj;
                return Arrays.hashCode(arr);
            }
            if (obj instanceof long[]) {
                long[] arr = (long[])obj;
                return Arrays.hashCode(arr);
            }
            if (obj instanceof short[]) {
                short[] arr = (short[])obj;
                return Arrays.hashCode(arr);
            }
        }
        return obj.hashCode();
    }

    public static String identityToString(@Nullable Object obj) {
        if (obj == null) {
            return "";
        }
        return obj.getClass().getName() + "@" + ObjectUtils.getIdentityHexString(obj);
    }

    public static String simpleIdentityToString(@Nullable Object obj) {
        if (obj == null) {
            return "";
        }
        String name = obj.getClass().isAnonymousClass() ? obj.getClass().getName() : obj.getClass().getSimpleName();
        return name + "@" + ObjectUtils.getIdentityHexString(obj);
    }

    @NonNull
    public static String simpleIdentityToString(@Nullable Object obj, @NonNull String name) {
        return ObjectUtils.simpleIdentityToString(obj) + "(" + name + ")";
    }

    @NonNull
    public static String getIdentityHexString(Object obj) {
        return Integer.toHexString(System.identityHashCode(obj));
    }
}

