/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.annotation.jsr305.NonNull;
import java.io.Writer;

public class OutputStringWriter
extends Writer {
    private StringBuilder buffer;
    private int initialSize;

    public OutputStringWriter() {
    }

    public OutputStringWriter(int initialSize) {
        this.initialSize = initialSize;
    }

    @Override
    public void write(int c) {
        this.touchBuffer().append((char)c);
    }

    @Override
    public void write(@NonNull char[] buf, int off, int len) {
        if (off < 0 || len < 0 || off + len > buf.length) {
            throw new IndexOutOfBoundsException("Invalid offset [" + off + "] and / or length [" + len + "] specified for array of size [" + buf.length + "]");
        }
        if (len > 0) {
            this.touchBuffer().append(buf, off, len);
        }
    }

    @Override
    public void write(@NonNull String str) {
        this.touchBuffer().append(str);
    }

    @Override
    public void write(@NonNull String str, int off, int len) {
        this.touchBuffer().append(str, off, off + len);
    }

    @Override
    public OutputStringWriter append(CharSequence csq) {
        if (csq == null) {
            this.write("null");
        } else {
            this.write(csq.toString());
        }
        return this;
    }

    @Override
    public OutputStringWriter append(CharSequence csq, int start, int end) {
        CharSequence cs = csq == null ? "null" : csq;
        this.write(cs.subSequence(start, end).toString());
        return this;
    }

    @Override
    public OutputStringWriter append(char c) {
        this.write(c);
        return this;
    }

    public String toString() {
        return this.buffer != null ? this.touchBuffer().toString() : "";
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }

    public boolean isDirty() {
        return this.buffer != null;
    }

    private StringBuilder touchBuffer() {
        if (this.buffer == null) {
            this.buffer = this.initialSize > 0 ? new StringBuilder(this.initialSize) : new StringBuilder();
        }
        return this.buffer;
    }
}

