/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.Assert;
import com.aspectran.utils.StringUtils;
import java.util.ArrayDeque;

public abstract class PathUtils {
    public static final String REGULAR_FILE_SEPARATOR = "/";
    public static final char REGULAR_FILE_SEPARATOR_CHAR = '/';
    public static final String WINDOWS_FILE_SEPARATOR = "\\";
    private static final String TOP_PATH = "..";
    private static final String CURRENT_PATH = ".";

    public static String applyRelativePath(String path, String relativePath) {
        Assert.notNull((Object)path, "path must not be null");
        Assert.notNull((Object)relativePath, "relativePath must not be null");
        int separatorIndex = path.lastIndexOf(47);
        if (separatorIndex != -1) {
            Object newPath = path.substring(0, separatorIndex);
            if (!relativePath.startsWith(REGULAR_FILE_SEPARATOR)) {
                newPath = (String)newPath + REGULAR_FILE_SEPARATOR;
            }
            return (String)newPath + relativePath;
        }
        return relativePath;
    }

    public static String cleanPath(String path) {
        int i;
        if (!StringUtils.hasLength(path)) {
            return path;
        }
        String normalizedPath = StringUtils.replace(path, WINDOWS_FILE_SEPARATOR, REGULAR_FILE_SEPARATOR);
        String pathToUse = normalizedPath;
        if (pathToUse.indexOf(46) == -1) {
            return pathToUse;
        }
        int prefixIndex = pathToUse.indexOf(58);
        Object prefix = "";
        if (prefixIndex != -1) {
            prefix = pathToUse.substring(0, prefixIndex + 1);
            if (((String)prefix).contains(REGULAR_FILE_SEPARATOR)) {
                prefix = "";
            } else {
                pathToUse = pathToUse.substring(prefixIndex + 1);
            }
        }
        if (pathToUse.startsWith(REGULAR_FILE_SEPARATOR)) {
            prefix = (String)prefix + REGULAR_FILE_SEPARATOR;
            pathToUse = pathToUse.substring(1);
        }
        String[] pathArray = StringUtils.split(pathToUse, REGULAR_FILE_SEPARATOR);
        ArrayDeque<String> pathElements = new ArrayDeque<String>(pathArray.length);
        int tops = 0;
        for (i = pathArray.length - 1; i >= 0; --i) {
            String element = pathArray[i];
            if (CURRENT_PATH.equals(element)) continue;
            if (TOP_PATH.equals(element)) {
                ++tops;
                continue;
            }
            if (tops > 0) {
                --tops;
                continue;
            }
            pathElements.addFirst(element);
        }
        if (pathArray.length == pathElements.size()) {
            return normalizedPath;
        }
        for (i = 0; i < tops; ++i) {
            pathElements.addFirst(TOP_PATH);
        }
        if (pathElements.size() == 1 && ((String)pathElements.getLast()).isEmpty() && !((String)prefix).endsWith(REGULAR_FILE_SEPARATOR)) {
            pathElements.addFirst(CURRENT_PATH);
        }
        String joined = StringUtils.toDelimitedString(pathElements, REGULAR_FILE_SEPARATOR);
        return ((String)prefix).isEmpty() ? joined : (String)prefix + joined;
    }

    public static boolean pathEquals(String path1, String path2) {
        return PathUtils.cleanPath(path1).equals(PathUtils.cleanPath(path2));
    }
}

