/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.Assert;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;

public class PrefixSuffixPattern {
    public static final char PREFIX_SUFFIX_SEPARATOR = '*';
    private String prefix;
    private String suffix;

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public boolean separate(String expression) {
        int start;
        int n = start = expression != null ? expression.indexOf(42) : -1;
        if (start == -1) {
            this.prefix = null;
            this.suffix = null;
            return false;
        }
        this.prefix = start > 0 ? expression.substring(0, start) : null;
        this.suffix = start < expression.length() - 1 ? expression.substring(start + 1) : null;
        return this.prefix != null || this.suffix != null || expression.charAt(0) == '*';
    }

    public String enclose(String infix) {
        return PrefixSuffixPattern.join(this.prefix, infix, this.suffix);
    }

    @NonNull
    public static String join(String prefix, String infix, String suffix) {
        Assert.notNull((Object)infix, "infix must not be null");
        if (prefix != null && suffix != null) {
            return prefix + infix + suffix;
        }
        if (prefix != null) {
            return prefix + infix;
        }
        if (suffix != null) {
            return infix + suffix;
        }
        return infix;
    }

    @Nullable
    public static PrefixSuffixPattern of(String expression) {
        PrefixSuffixPattern pattern;
        if (StringUtils.hasLength(expression) && (pattern = new PrefixSuffixPattern()).separate(expression)) {
            return pattern;
        }
        return null;
    }
}

