/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.Assert;
import com.aspectran.utils.Win32ConsoleCtrlCloseHook;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;

public class ShutdownHook {
    private static final Logger logger = LoggerFactory.getLogger(ShutdownHook.class);
    private static final List<Task> tasks = new ArrayList<Task>();
    private static Thread hook;
    private static Win32ConsoleCtrlCloseHook win32ConsoleCtrlCloseHook;

    public static synchronized <T extends Task> T addTask(T task) {
        Assert.notNull(task, "task must not be null");
        if (hook == null) {
            hook = new Thread("shutdown"){

                @Override
                public void run() {
                    ShutdownHook.runTasks();
                    if (logger.isDebugEnabled()) {
                        logger.debug("Removed shutdown-hook: " + String.valueOf(hook));
                    }
                }
            };
            ShutdownHook.registerHook(hook);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Adding shutdown-hook task: " + String.valueOf(task));
        }
        tasks.add(task);
        return task;
    }

    public static synchronized void removeTask(Task task) {
        Assert.notNull((Object)task, "task must not be null");
        if (hook == null) {
            return;
        }
        if (tasks.remove(task) && logger.isDebugEnabled()) {
            logger.debug("Removed shutdown-hook task: " + String.valueOf(task));
        }
        if (tasks.isEmpty()) {
            ShutdownHook.releaseHook(hook);
            hook = null;
        }
    }

    private static void registerHook(Thread thread) {
        if (logger.isDebugEnabled()) {
            logger.debug("Registering shutdown-hook: " + String.valueOf(thread));
        }
        Runtime.getRuntime().addShutdownHook(thread);
        try {
            win32ConsoleCtrlCloseHook = Win32ConsoleCtrlCloseHook.register(hook);
        }
        catch (NoClassDefFoundError e) {
            win32ConsoleCtrlCloseHook = null;
            logger.warn(e);
        }
    }

    private static void releaseHook(Thread thread) {
        if (logger.isDebugEnabled()) {
            logger.debug("Removing shutdown-hook: " + String.valueOf(thread));
        }
        try {
            Runtime.getRuntime().removeShutdownHook(thread);
        }
        catch (IllegalStateException e) {
            logger.warn(e);
        }
        if (win32ConsoleCtrlCloseHook != null) {
            win32ConsoleCtrlCloseHook.release();
            win32ConsoleCtrlCloseHook = null;
        }
    }

    private static synchronized void runTasks() {
        if (logger.isDebugEnabled()) {
            logger.debug("Running all shutdown-hook tasks: " + tasks.size());
        }
        ArrayList<Task> list = new ArrayList<Task>(tasks);
        int count = 0;
        ListIterator iter = list.listIterator(list.size());
        while (iter.hasPrevious()) {
            Task task = (Task)iter.previous();
            if (tasks.contains(task)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Running task [" + ++count + "/" + list.size() + "]: " + String.valueOf(task));
                }
                try {
                    task.run();
                }
                catch (Throwable e) {
                    logger.warn("Failed to run task: " + String.valueOf(task), e);
                }
                continue;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("Task already run or removed [" + ++count + "/" + list.size() + "]: " + String.valueOf(task));
        }
        tasks.clear();
    }

    public static interface Task {
        public void run() throws Exception;
    }

    public static class Manager {
        private Task task;

        public void register(Task task) {
            if (this.task == null) {
                this.task = ShutdownHook.addTask(task);
            }
        }

        public void remove() {
            if (this.task != null) {
                ShutdownHook.removeTask(this.task);
                this.task = null;
            }
        }

        @NonNull
        public static Manager create(Task task) {
            Manager manager = new Manager();
            manager.register(task);
            return manager;
        }
    }
}

