/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.annotation.jsr305.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;

public abstract class StringUtils {
    public static final String EMPTY = "";
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String nullToEmpty(String str) {
        return str != null ? str : EMPTY;
    }

    public static String emptyToNull(String str) {
        return str == null || str.isEmpty() ? null : str;
    }

    public static boolean hasLength(CharSequence chars) {
        return chars != null && !chars.isEmpty();
    }

    public static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    public static boolean hasText(CharSequence chars) {
        return chars != null && !chars.isEmpty() && StringUtils.containsText(chars);
    }

    public static boolean hasText(String str) {
        return str != null && !str.isEmpty() && StringUtils.containsText(str);
    }

    private static boolean containsText(@NonNull CharSequence chars) {
        int strLen = chars.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(chars.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(CharSequence chars) {
        if (!StringUtils.hasLength(chars)) {
            return false;
        }
        int strLen = chars.length();
        for (int i = 0; i < strLen; ++i) {
            if (!Character.isWhitespace(chars.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean containsWhitespace(String str) {
        return StringUtils.containsWhitespace((CharSequence)str);
    }

    public static String trimWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (!buf.isEmpty() && Character.isWhitespace(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        while (!buf.isEmpty() && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String trimAllWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        int index = 0;
        while (buf.length() > index) {
            if (Character.isWhitespace(buf.charAt(index))) {
                buf.deleteCharAt(index);
                continue;
            }
            ++index;
        }
        return buf.toString();
    }

    public static String trimLeadingWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (!buf.isEmpty() && Character.isWhitespace(buf.charAt(0))) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    public static String trimTrailingWhitespace(String str) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (!buf.isEmpty() && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static String trimLeadingCharacter(String str, char leadingChar) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (!buf.isEmpty() && buf.charAt(0) == leadingChar) {
            buf.deleteCharAt(0);
        }
        return buf.toString();
    }

    public static String trimTrailingCharacter(String str, char trailingChar) {
        if (!StringUtils.hasLength(str)) {
            return str;
        }
        StringBuilder buf = new StringBuilder(str);
        while (!buf.isEmpty() && buf.charAt(buf.length() - 1) == trailingChar) {
            buf.deleteCharAt(buf.length() - 1);
        }
        return buf.toString();
    }

    public static boolean startsWithIgnoreCase(String str, String prefix) {
        return str != null && prefix != null && str.length() >= prefix.length() && str.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return str != null && suffix != null && str.length() >= suffix.length() && str.regionMatches(true, str.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean startsWith(String str, char prefix) {
        return str != null && !str.isEmpty() && str.charAt(0) == prefix;
    }

    public static boolean endsWith(String str, char suffix) {
        return str != null && !str.isEmpty() && str.charAt(str.length() - 1) == suffix;
    }

    public static String replace(String str, String search, String replacement) {
        int index;
        if (str == null || search == null || replacement == null) {
            return str;
        }
        StringBuilder sb = new StringBuilder();
        int searchLen = search.length();
        int stringLen = str.length();
        int oldIndex = 0;
        while ((index = str.indexOf(search, oldIndex)) >= 0) {
            sb.append(str, oldIndex, index);
            sb.append(replacement);
            oldIndex = index + searchLen;
        }
        if (oldIndex < stringLen) {
            sb.append(str, oldIndex, stringLen);
        }
        return sb.toString();
    }

    public static String replace(String str, String[] searchList, String[] replacementList) {
        if (str == null || searchList == null || replacementList == null) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        int loop = Math.min(searchList.length, replacementList.length);
        int start = 0;
        for (int i = 0; i < loop; ++i) {
            if (searchList[i] == null || replacementList[i] == null) continue;
            int searchLen = searchList[i].length();
            int replaceLen = replacementList[i].length();
            while (!sb.isEmpty() && (start = sb.indexOf(searchList[i], start + replaceLen)) != -1) {
                int end = start + searchLen;
                sb.replace(start, end, replacementList[i]);
            }
        }
        return sb.toString();
    }

    @NonNull
    public static String replaceLast(@NonNull String str, @NonNull String searchStr, @NonNull String replacement) {
        int pos = str.lastIndexOf(searchStr);
        if (pos > -1) {
            return str.substring(0, pos) + replacement + str.substring(pos + searchStr.length());
        }
        return str;
    }

    public static String repeat(char ch, int repeat) {
        if (repeat <= 0) {
            return EMPTY;
        }
        if (repeat == 1) {
            return String.valueOf(ch);
        }
        char[] buf = new char[repeat];
        for (int i = repeat - 1; i >= 0; --i) {
            buf[i] = ch;
        }
        return new String(buf);
    }

    public static String[] split(String str, String delim) {
        if (StringUtils.isEmpty(str)) {
            return EMPTY_STRING_ARRAY;
        }
        int cnt = StringUtils.search(str, delim);
        String[] item = new String[cnt + 1];
        if (cnt == 0) {
            item[0] = str;
            return item;
        }
        int idx = 0;
        int pos1 = 0;
        int pos2 = str.indexOf(delim);
        int delimLen = delim.length();
        while (pos2 >= 0) {
            item[idx++] = pos1 > pos2 - 1 ? EMPTY : str.substring(pos1, pos2);
            pos1 = pos2 + delimLen;
            pos2 = str.indexOf(delim, pos1);
        }
        if (pos1 < str.length()) {
            item[idx] = str.substring(pos1);
        }
        if (item[cnt] == null) {
            item[cnt] = EMPTY;
        }
        return item;
    }

    @NonNull
    public static String[] split(String str, String delim, int size) {
        String[] arr1 = new String[size];
        String[] arr2 = StringUtils.split(str, delim);
        for (int i = 0; i < arr1.length; ++i) {
            arr1[i] = i < arr2.length ? arr2[i] : EMPTY;
        }
        return arr1;
    }

    public static String[] split(String str, char delim) {
        if (StringUtils.isEmpty(str)) {
            return EMPTY_STRING_ARRAY;
        }
        int cnt = StringUtils.search((CharSequence)str, delim);
        String[] item = new String[cnt + 1];
        if (cnt == 0) {
            item[0] = str;
            return item;
        }
        int idx = 0;
        int pos1 = 0;
        int pos2 = str.indexOf(delim);
        while (pos2 >= 0) {
            item[idx++] = pos1 > pos2 - 1 ? EMPTY : str.substring(pos1, pos2);
            pos1 = pos2 + 1;
            pos2 = str.indexOf(delim, pos1);
        }
        if (pos1 < str.length()) {
            item[idx] = str.substring(pos1);
        }
        if (item[cnt] == null) {
            item[cnt] = EMPTY;
        }
        return item;
    }

    @NonNull
    public static String[] split(String str, char delim, int size) {
        String[] arr1 = new String[size];
        String[] arr2 = StringUtils.split(str, delim);
        for (int i = 0; i < arr1.length; ++i) {
            arr1[i] = i < arr2.length ? arr2[i] : EMPTY;
        }
        return arr1;
    }

    public static int search(@NonNull String str, @NonNull String searchStr) {
        int strLen = str.length();
        int keywLen = searchStr.length();
        int pos = 0;
        int cnt = 0;
        if (keywLen == 0) {
            return 0;
        }
        while ((pos = str.indexOf(searchStr, pos)) != -1) {
            ++cnt;
            if ((pos += keywLen) < strLen) continue;
            break;
        }
        return cnt;
    }

    public static int searchIgnoreCase(@NonNull String str, @NonNull String searchStr) {
        return StringUtils.search(str.toLowerCase(), searchStr.toLowerCase());
    }

    public static int search(@NonNull CharSequence chars, char c) {
        int count = 0;
        for (int i = 0; i < chars.length(); ++i) {
            if (chars.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public static int searchIgnoreCase(@NonNull CharSequence chars, char searchChar) {
        int count = 0;
        char cl = Character.toLowerCase(searchChar);
        for (int i = 0; i < chars.length(); ++i) {
            if (Character.toLowerCase(chars.charAt(i)) != cl) continue;
            ++count;
        }
        return count;
    }

    public static String[] tokenize(String str, String delimiters) {
        return StringUtils.tokenize(str, delimiters, false);
    }

    public static String[] tokenize(String str, String delimiters, boolean trim) {
        if (str == null) {
            return EMPTY_STRING_ARRAY;
        }
        StringTokenizer st = new StringTokenizer(trim ? str.trim() : str, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            tokens.add(trim ? token.trim() : token);
        }
        return tokens.toArray(EMPTY_STRING_ARRAY);
    }

    public static String toDelimitedString(Object[] arr, String delim) {
        if (arr == null || arr.length == 0) {
            return EMPTY;
        }
        if (arr.length == 1) {
            return arr[0] == null ? EMPTY : arr[0].toString();
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < arr.length; ++i) {
            if (i > 0) {
                sb.append(delim);
            }
            sb.append(arr[i]);
        }
        return sb.toString();
    }

    public static String toDelimitedString(Collection<?> collection, String delim) {
        if (collection == null || collection.isEmpty()) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Object o : collection) {
            if (!first) {
                sb.append(delim);
            }
            sb.append(o);
            first = false;
        }
        return sb.toString();
    }

    public static String toLineDelimitedString(Object[] arr) {
        return StringUtils.toDelimitedString(arr, System.lineSeparator());
    }

    public static String toLineDelimitedString(Collection<?> collection) {
        return StringUtils.toDelimitedString(collection, System.lineSeparator());
    }

    public static String[] splitCommaDelimitedString(String str) {
        return StringUtils.tokenize(str, ",", true);
    }

    public static String joinCommaDelimitedList(String[] arr) {
        return StringUtils.toDelimitedString(arr, ", ");
    }

    public static String joinCommaDelimitedList(Collection<?> collection) {
        return StringUtils.toDelimitedString(collection, ", ");
    }

    public static String[] toStringArray(Collection<String> collection) {
        return collection != null && !collection.isEmpty() ? collection.toArray(EMPTY_STRING_ARRAY) : EMPTY_STRING_ARRAY;
    }

    public static String[] toStringArray(Enumeration<String> enumeration) {
        return enumeration != null ? StringUtils.toStringArray(Collections.list(enumeration)) : EMPTY_STRING_ARRAY;
    }

    @NonNull
    public static String toHumanFriendlyByteSize(long bytes) {
        int z;
        double d;
        if (bytes < 1024L && bytes > -1024L) {
            return bytes + " B";
        }
        String minus = null;
        if (bytes < 0L) {
            minus = "-";
            bytes = -bytes;
        }
        String format = (d = (double)bytes / (double)(1L << (z = (63 - Long.numberOfLeadingZeros(bytes)) / 10) * 10)) % 1.0 == 0.0 ? "%s%.0f %sB" : "%s%.1f %sB";
        return String.format(format, StringUtils.nullToEmpty(minus), d, Character.valueOf(" KMGTPE".charAt(z)));
    }

    public static long toMachineFriendlyByteSize(@NonNull String bytes) {
        double d;
        try {
            d = Double.parseDouble(bytes.replaceAll("[GMK]?B?$", EMPTY));
        }
        catch (NumberFormatException e) {
            String msg = "Size must be specified as bytes (B), kilobytes (KB), megabytes (MB), gigabytes (GB). E.g. 1024, 1KB, 10M, 10MB, 100G, 100GB";
            throw new NumberFormatException(msg + " " + e.getMessage());
        }
        long l = Math.round(d * 1024.0 * 1024.0 * 1024.0);
        int index = Math.max(0, bytes.length() - (bytes.endsWith("B") ? 2 : 1));
        switch (bytes.charAt(index)) {
            default: {
                l /= 1024L;
            }
            case 'K': {
                l /= 1024L;
            }
            case 'M': {
                l /= 1024L;
            }
            case 'G': 
        }
        return l;
    }
}

