/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.Assert;
import com.aspectran.utils.BooleanUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;

public class StringifyContext
implements Cloneable {
    private Boolean pretty;
    private int indentSize = -1;
    private boolean indentTab;
    private Boolean nullWritable;
    private String dateTimeFormat;
    private String dateFormat;
    private String timeFormat;
    private Locale locale;
    private DateTimeFormatter dateTimeFormatter;
    private DateTimeFormatter dateFormatter;
    private DateTimeFormatter timeFormatter;

    public boolean hasPretty() {
        return this.pretty != null;
    }

    public boolean isPretty() {
        return BooleanUtils.toBoolean(this.pretty);
    }

    public void setPretty(Boolean pretty) {
        this.pretty = pretty;
    }

    public boolean hasIndentSize() {
        return this.indentSize > -1;
    }

    public int getIndentSize() {
        return this.indentSize;
    }

    public void setIndentSize(int indentSize) {
        this.indentSize = indentSize;
    }

    public void setIndentTab(boolean indentTab) {
        this.indentTab = indentTab;
    }

    @Nullable
    public String getIndentString() {
        if (this.indentTab) {
            return "\t";
        }
        if (this.indentSize == 1) {
            return " ";
        }
        if (this.indentSize > 0) {
            return StringUtils.repeat(' ', this.indentSize);
        }
        return null;
    }

    public boolean hasDateTimeFormat() {
        return this.dateTimeFormat != null;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
        this.dateTimeFormatter = null;
    }

    public boolean hasDateFormat() {
        return this.dateFormat != null;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
        this.dateFormatter = null;
    }

    public boolean hasTimeFormat() {
        return this.timeFormat != null;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public void setTimeFormat(String timeFormat) {
        this.timeFormat = timeFormat;
        this.timeFormatter = null;
    }

    public boolean hasLocale() {
        return this.locale != null;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
        this.dateTimeFormatter = null;
        this.dateFormatter = null;
        this.timeFormatter = null;
    }

    public boolean hasNullWritable() {
        return this.nullWritable != null;
    }

    public boolean isNullWritable() {
        return BooleanUtils.toBoolean(this.nullWritable);
    }

    public void setNullWritable(Boolean nullWritable) {
        this.nullWritable = nullWritable;
    }

    public String toString(LocalDateTime localDateTime) {
        return this.toString(localDateTime, null);
    }

    public String toString(LocalDateTime localDateTime, String format) {
        Assert.notNull((Object)localDateTime, "localDateTime must not be null");
        DateTimeFormatter dateTimeFormatter = this.touchDateTimeFormatter(format);
        if (dateTimeFormatter != null) {
            return localDateTime.format(dateTimeFormatter);
        }
        return localDateTime.toString();
    }

    public String toString(LocalDate localDate) {
        return this.toString(localDate, null);
    }

    public String toString(LocalDate localDate, String format) {
        Assert.notNull((Object)localDate, "localDate must not be null");
        DateTimeFormatter dateTimeFormatter = this.touchDateFormatter(format);
        if (dateTimeFormatter != null) {
            return localDate.format(dateTimeFormatter);
        }
        return localDate.toString();
    }

    public String toString(LocalTime localTime) {
        return this.toString(localTime, null);
    }

    public String toString(LocalTime localTime, String format) {
        Assert.notNull((Object)localTime, "localTime must not be null");
        DateTimeFormatter dateTimeFormatter = this.touchTimeFormatter(format);
        if (dateTimeFormatter != null) {
            return localTime.format(dateTimeFormatter);
        }
        return localTime.toString();
    }

    public String toString(Date date) {
        return this.toString(date, null);
    }

    public String toString(Date date, String format) {
        Assert.notNull((Object)date, "date must not be null");
        DateTimeFormatter dateTimeFormatter = this.touchDateTimeFormatter(format);
        if (dateTimeFormatter != null) {
            LocalDateTime ldt = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            return ldt.format(dateTimeFormatter);
        }
        return date.toString();
    }

    public LocalDateTime toLocalDateTime(String dateTime) {
        return this.toLocalDateTime(dateTime, null);
    }

    public LocalDateTime toLocalDateTime(String dateTime, String format) {
        Assert.notNull((Object)dateTime, "dateTime must not be null");
        DateTimeFormatter dateTimeFormatter = this.touchDateTimeFormatter(format);
        return LocalDateTime.parse(dateTime, dateTimeFormatter);
    }

    public LocalDate toLocalDate(String date) {
        return this.toLocalDate(date, null);
    }

    public LocalDate toLocalDate(String date, String format) {
        Assert.notNull((Object)date, "date must not be null");
        DateTimeFormatter dateTimeFormatter = this.touchDateFormatter(format);
        return LocalDate.parse(date, dateTimeFormatter);
    }

    public LocalTime toLocalTime(String time) {
        return this.toLocalTime(time, null);
    }

    public LocalTime toLocalTime(String time, String format) {
        Assert.notNull((Object)time, "time must not be null");
        DateTimeFormatter dateTimeFormatter = this.touchTimeFormatter(format);
        return LocalTime.parse(time, dateTimeFormatter);
    }

    public Date toDate(String date) throws ParseException {
        return this.toDate(date, null);
    }

    public Date toDate(String date, String format) throws ParseException {
        Assert.notNull((Object)date, "date must not be null");
        if (format != null) {
            return this.createSimpleDateFormat(format, this.locale).parse(date);
        }
        return this.createSimpleDateFormat(this.dateTimeFormat, this.locale).parse(date);
    }

    private DateTimeFormatter touchDateTimeFormatter(String format) {
        if (format != null) {
            return this.createDateTimeFormatter(format, this.locale);
        }
        if (this.dateTimeFormat != null && this.dateTimeFormatter == null) {
            this.dateTimeFormatter = this.createDateTimeFormatter(this.dateTimeFormat, this.locale);
        }
        return this.dateTimeFormatter;
    }

    private DateTimeFormatter touchDateFormatter(String format) {
        if (format != null) {
            return this.createDateTimeFormatter(format, this.locale);
        }
        if (this.dateFormat != null && this.dateFormatter == null) {
            this.dateFormatter = this.createDateTimeFormatter(this.dateFormat, this.locale);
        }
        return this.dateFormatter;
    }

    private DateTimeFormatter touchTimeFormatter(String format) {
        if (format != null) {
            return this.createDateTimeFormatter(format, this.locale);
        }
        if (this.timeFormat != null && this.timeFormatter == null) {
            this.timeFormatter = this.createDateTimeFormatter(this.timeFormat, this.locale);
        }
        return this.timeFormatter;
    }

    @NonNull
    private DateTimeFormatter createDateTimeFormatter(String format, Locale locale) {
        if (locale != null) {
            return DateTimeFormatter.ofPattern(format, locale);
        }
        return DateTimeFormatter.ofPattern(format);
    }

    @NonNull
    private SimpleDateFormat createSimpleDateFormat(String format, Locale locale) {
        Assert.notNull((Object)format, "format must not be null");
        if (locale != null) {
            return new SimpleDateFormat(format, locale);
        }
        return new SimpleDateFormat(format);
    }

    public StringifyContext clone() {
        try {
            return (StringifyContext)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("pretty", this.pretty);
        if (this.indentSize > -1) {
            tsb.append("indentSize", this.indentSize);
        }
        tsb.append("indentTab", this.indentTab);
        tsb.append("nullWritable", this.nullWritable);
        tsb.append("dateTimeFormat", this.dateTimeFormat);
        tsb.append("dateFormat", this.dateFormat);
        tsb.append("timeFormat", this.timeFormat);
        tsb.append("locale", this.locale);
        return tsb.toString();
    }
}

