/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.ObjectUtils;
import com.aspectran.utils.StringifyContext;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.Parameter;
import com.aspectran.utils.apon.Parameters;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public class ToStringBuilder {
    private final StringBuilder buffer;
    private StringifyContext stringifyContext;
    private boolean braced = false;
    private int start = -1;

    public ToStringBuilder() {
        this(null);
    }

    public ToStringBuilder(String name) {
        this(name, 64);
    }

    public ToStringBuilder(int capacity) {
        this(null, capacity);
    }

    public ToStringBuilder(String name, int capacity) {
        this.buffer = new StringBuilder(capacity);
        this.labeling(name, true);
    }

    private ToStringBuilder(Object value, StringifyContext stringifyContext) {
        this(null, value, stringifyContext);
    }

    private ToStringBuilder(String name, Object value, StringifyContext stringifyContext) {
        this.buffer = new StringBuilder(128);
        this.setStringifyContext(stringifyContext);
        if (name != null) {
            this.labeling(name, false);
        }
        if (value != null) {
            this.appendValue(value);
        }
    }

    private void labeling(String name, boolean braced) {
        if (name != null) {
            this.buffer.append(name).append(" ");
        }
        if (braced) {
            this.appendOpenBrace();
        }
        this.braced = braced;
        this.start = this.buffer.length();
    }

    public void setStringifyContext(StringifyContext stringifyContext) {
        this.stringifyContext = stringifyContext;
    }

    public ToStringBuilder apply(StringifyContext stringifyContext) {
        this.setStringifyContext(stringifyContext);
        return this;
    }

    public ToStringBuilder append(String name, Object value) {
        if (value != null) {
            this.appendName(name);
            this.appendValue(value);
        }
        return this;
    }

    public ToStringBuilder appendForce(String name, Object value) {
        this.appendName(name);
        this.appendValue(value);
        return this;
    }

    public ToStringBuilder append(String name, Class<?> clazz) {
        if (clazz != null) {
            this.appendName(name);
            this.appendValue(clazz.getTypeName());
        }
        return this;
    }

    public ToStringBuilder append(String name, Method method) {
        if (method != null) {
            this.appendName(name);
            this.appendValue(method);
        }
        return this;
    }

    public ToStringBuilder append(String name, boolean value) {
        if (value) {
            this.appendName(name);
            this.buffer.append(true);
        }
        return this;
    }

    public ToStringBuilder appendForce(String name, boolean value) {
        this.appendName(name);
        this.buffer.append(value);
        return this;
    }

    public ToStringBuilder appendEqual(String name, Object value, Object compare) {
        if (value != null && value.equals(compare)) {
            this.appendName(name);
            this.appendValue(value);
        }
        return this;
    }

    public ToStringBuilder appendNotEqual(String name, Object value, Object compare) {
        if (value != null && !value.equals(compare)) {
            this.appendName(name);
            this.appendValue(value);
        }
        return this;
    }

    public ToStringBuilder appendSize(String name, Object object) {
        if (object != null) {
            this.appendName(name);
            if (object instanceof Map) {
                Map map = (Map)object;
                this.buffer.append(map.size());
            } else if (object instanceof Collection) {
                Collection collection = (Collection)object;
                this.buffer.append(collection.size());
            } else if (object instanceof Iterator) {
                Iterator iterator = (Iterator)object;
                int count = 0;
                while (iterator.hasNext()) {
                    ++count;
                    iterator.next();
                }
                this.buffer.append(count);
            } else if (object instanceof Enumeration) {
                Enumeration enumeration = (Enumeration)object;
                int count = 0;
                while (enumeration.hasMoreElements()) {
                    ++count;
                    enumeration.nextElement();
                }
                this.buffer.append(count);
            } else if (object.getClass().isArray()) {
                this.buffer.append(Array.getLength(object));
            } else {
                this.buffer.append(object.toString().length());
            }
        }
        return this;
    }

    private void appendOpenBrace() {
        this.buffer.append("{");
    }

    private void appendCloseBrace() {
        this.buffer.append("}");
    }

    private void appendOpenBracket() {
        this.buffer.append("[");
    }

    private void appendCloseBracket() {
        this.buffer.append("]");
    }

    private void appendComma() {
        this.buffer.append(", ");
    }

    private void appendName(Object name) {
        this.appendName(name, this.start);
    }

    private void appendName(Object name, int index) {
        if (this.buffer.length() > index) {
            this.appendComma();
        }
        this.buffer.append(name).append("=");
    }

    private void appendValue(Object object) {
        if (object instanceof CharSequence) {
            CharSequence charSequence = (CharSequence)object;
            this.buffer.append(charSequence);
        } else if (object instanceof Map) {
            Map map = (Map)object;
            this.appendValue(map);
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            this.appendValue(collection);
        } else if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            this.appendValue(iterator);
        } else if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            this.appendValue(enumeration);
        } else if (object instanceof Parameters) {
            Parameters parameters = (Parameters)object;
            this.appendValue(parameters);
        } else if (object.getClass().isArray()) {
            this.appendArrayValue(object);
        } else if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            if (this.stringifyContext != null) {
                this.buffer.append(this.stringifyContext.toString(localDateTime));
            } else {
                this.buffer.append(localDateTime);
            }
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            if (this.stringifyContext != null) {
                this.buffer.append(this.stringifyContext.toString(localDate));
            } else {
                this.buffer.append(localDate);
            }
        } else if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            if (this.stringifyContext != null) {
                this.buffer.append(this.stringifyContext.toString(localTime));
            } else {
                this.buffer.append(localTime);
            }
        } else if (object instanceof Date) {
            Date date = (Date)object;
            if (this.stringifyContext != null) {
                this.buffer.append(this.stringifyContext.toString(date));
            } else {
                this.buffer.append(date);
            }
        } else {
            this.buffer.append(object);
        }
    }

    private void appendValue(@NonNull Map<?, ?> map) {
        this.appendOpenBrace();
        int index = this.buffer.length();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            ToStringBuilder.checkCircularReference(map, value);
            this.appendName(key, index);
            this.appendValue(value);
        }
        this.appendCloseBrace();
    }

    private void appendValue(@NonNull Collection<?> list) {
        this.appendOpenBracket();
        int index = this.buffer.length();
        for (Object value : list) {
            ToStringBuilder.checkCircularReference(list, value);
            if (this.buffer.length() > index) {
                this.appendComma();
            }
            this.appendValue(value);
        }
        this.appendCloseBracket();
    }

    private void appendValue(@NonNull Iterator<?> iterator) {
        this.appendOpenBracket();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            ToStringBuilder.checkCircularReference(iterator, value);
            this.appendValue(value);
            if (!iterator.hasNext()) continue;
            this.appendComma();
        }
        this.appendCloseBracket();
    }

    private void appendValue(@NonNull Enumeration<?> enumeration) {
        this.appendOpenBracket();
        while (enumeration.hasMoreElements()) {
            Object value = enumeration.nextElement();
            ToStringBuilder.checkCircularReference(enumeration, value);
            this.appendValue(value);
            if (!enumeration.hasMoreElements()) continue;
            this.appendComma();
        }
        this.appendCloseBracket();
    }

    private void appendValue(@NonNull Parameters parameters) {
        this.appendOpenBrace();
        int index = this.buffer.length();
        for (Parameter parameter : parameters.getParameterValues()) {
            String name = parameter.getName();
            Object value = parameter.getValue();
            if (value == null) continue;
            ToStringBuilder.checkCircularReference(parameters, value);
            this.appendName(name, index);
            this.appendValue(value);
        }
        this.appendCloseBrace();
    }

    private void appendArrayValue(Object object) {
        this.appendOpenBracket();
        int len = Array.getLength(object);
        for (int i = 0; i < len; ++i) {
            Object value = Array.get(object, i);
            ToStringBuilder.checkCircularReference(object, value);
            if (i > 0) {
                this.appendComma();
            }
            this.appendValue(value);
        }
        this.appendCloseBracket();
    }

    private void appendValue(@NonNull Method method) {
        this.buffer.append(method.getDeclaringClass().getTypeName());
        this.buffer.append('.');
        this.buffer.append(method.getName());
        this.buffer.append('(');
        Class<?>[] types = method.getParameterTypes();
        for (int i = 0; i < types.length; ++i) {
            if (i > 0) {
                this.appendComma();
            }
            this.buffer.append(types[i].getTypeName());
        }
        this.buffer.append(')');
    }

    public String toString() {
        if (this.braced) {
            return String.valueOf(this.buffer) + "}";
        }
        return this.buffer.toString();
    }

    private static void checkCircularReference(Object wrapper, Object member) {
        if (wrapper == member) {
            throw new IllegalArgumentException("Serialization Failure: Circular reference was detected while serializing object " + ObjectUtils.identityToString(wrapper) + " " + String.valueOf(wrapper));
        }
    }

    public static String toString(Object object) {
        return ToStringBuilder.toString(object, null);
    }

    public static String toString(String name, Object object) {
        return ToStringBuilder.toString(name, object, null);
    }

    public static String toString(Object object, StringifyContext stringifyContext) {
        return new ToStringBuilder(object, stringifyContext).toString();
    }

    public static String toString(String name, Object object, StringifyContext stringifyContext) {
        return new ToStringBuilder(name, object, stringifyContext).toString();
    }
}

