/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils;

import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.sun.jna.Native;
import com.sun.jna.win32.StdCallLibrary;

public class Win32ConsoleCtrlCloseHook
implements StdCallLibrary.StdCallCallback {
    private static final Logger logger = LoggerFactory.getLogger(Win32ConsoleCtrlCloseHook.class);
    private static final boolean IS_WIN = System.getProperty("os.name").toLowerCase().contains("win");
    private static final int CTRL_CLOSE_EVENT = 2;
    private final Thread hook;

    private Win32ConsoleCtrlCloseHook(Thread hook) {
        this.hook = hook;
    }

    public boolean callback(long dwCtrlType) {
        if ((int)dwCtrlType == 2) {
            if (logger.isDebugEnabled()) {
                logger.debug("Win32ConsoleCtrlHandler receives event " + dwCtrlType);
            }
            this.hook.start();
            while (true) {
                try {
                    this.hook.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
            return true;
        }
        return false;
    }

    private Win32ConsoleCtrlCloseHook register() {
        this.SetConsoleCtrlHandler(this, true);
        return this;
    }

    public void release() {
        this.SetConsoleCtrlHandler(this, false);
    }

    private native boolean SetConsoleCtrlHandler(StdCallLibrary.StdCallCallback var1, boolean var2);

    @Nullable
    public static Win32ConsoleCtrlCloseHook register(Thread hook) {
        if (!IS_WIN) {
            return null;
        }
        try {
            Native.register((String)"kernel32");
            if (logger.isDebugEnabled()) {
                logger.debug("Windows/Kernel32 library loaded");
            }
            Win32ConsoleCtrlCloseHook win32ConsoleCtrlCloseHook = new Win32ConsoleCtrlCloseHook(hook);
            return win32ConsoleCtrlCloseHook.register();
        }
        catch (NoClassDefFoundError e) {
            logger.warn("JNA not found. Native methods and handlers will be disabled.");
        }
        catch (UnsatisfiedLinkError e) {
            logger.warn("Unable to link Windows/Kernel32 library. Native methods and handlers will be disabled.");
        }
        return null;
    }
}

