/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.apon;

import com.aspectran.utils.Assert;
import com.aspectran.utils.BooleanUtils;
import com.aspectran.utils.ClassUtils;
import com.aspectran.utils.ObjectUtils;
import com.aspectran.utils.ToStringBuilder;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.AponParseException;
import com.aspectran.utils.apon.AponReader;
import com.aspectran.utils.apon.AponWriter;
import com.aspectran.utils.apon.Parameter;
import com.aspectran.utils.apon.ParameterKey;
import com.aspectran.utils.apon.ParameterValue;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.apon.UnknownParameterException;
import com.aspectran.utils.apon.ValueType;
import com.aspectran.utils.apon.VariableParameters;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractParameters
implements Parameters {
    private final Map<String, ParameterValue> parameterValueMap;
    private final Map<String, ParameterValue> altParameterValueMap;
    private final Set<String> parameterNames;
    private final boolean structureFixed;
    private Parameter proprietor;
    private String actualName;

    protected AbstractParameters(ParameterKey[] parameterKeys) {
        LinkedHashMap<String, ParameterValue> valueMap = new LinkedHashMap<String, ParameterValue>();
        if (parameterKeys != null) {
            HashMap<String, ParameterValue> altValueMap = new HashMap<String, ParameterValue>();
            LinkedHashSet<String> parameterNames = new LinkedHashSet<String>();
            for (ParameterKey pk : parameterKeys) {
                ParameterValue pv = pk.newParameterValue();
                pv.setContainer(this);
                valueMap.put(pk.getName(), pv);
                parameterNames.add(pk.getName());
                if (pk.getAltNames() == null) continue;
                for (String altName : pk.getAltNames()) {
                    altValueMap.put(altName, pv);
                }
            }
            this.parameterValueMap = Collections.unmodifiableMap(valueMap);
            this.altParameterValueMap = altValueMap.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(altValueMap);
            this.parameterNames = Collections.unmodifiableSet(parameterNames);
            this.structureFixed = true;
        } else {
            this.parameterValueMap = valueMap;
            this.altParameterValueMap = Collections.emptyMap();
            this.parameterNames = null;
            this.structureFixed = false;
        }
    }

    @Override
    public boolean isStructureFixed() {
        return this.structureFixed;
    }

    @Override
    public Parameter getProprietor() {
        return this.proprietor;
    }

    @Override
    public void setProprietor(Parameter proprietor) {
        this.proprietor = proprietor;
    }

    @Override
    public Parameter getParent() {
        if (this.proprietor != null && this.proprietor.getContainer() != null) {
            return this.proprietor.getContainer().getProprietor();
        }
        return null;
    }

    @Override
    public String getActualName() {
        if (this.proprietor == null) {
            return this.actualName;
        }
        return this.actualName != null ? this.actualName : this.proprietor.getName();
    }

    @Override
    public void setActualName(String actualName) {
        this.actualName = actualName;
    }

    @Override
    public String getQualifiedName() {
        if (this.proprietor != null) {
            return this.proprietor.getQualifiedName();
        }
        return this.getClass().getName();
    }

    @Override
    public String getQualifiedName(String name) {
        ParameterValue pv = this.getParameterValue(name);
        return pv.getQualifiedName();
    }

    @Override
    public String getQualifiedName(ParameterKey key) {
        this.checkKey(key);
        ParameterValue pv = this.getParameterValue(key.getName());
        return pv.getQualifiedName();
    }

    @Override
    public ParameterValue getParameterValue(String name) {
        Assert.notNull((Object)name, "name must not be null");
        ParameterValue pv = this.parameterValueMap.get(name);
        if (pv != null) {
            return pv;
        }
        if (this.structureFixed) {
            return this.altParameterValueMap.get(name);
        }
        return null;
    }

    @Override
    public ParameterValue getParameterValue(ParameterKey key) {
        this.checkKey(key);
        return this.getParameterValue(key.getName());
    }

    @Override
    @NonNull
    public Collection<ParameterValue> getParameterValues() {
        return this.parameterValueMap.values();
    }

    @Override
    @NonNull
    public String[] getParameterNames() {
        return this.parameterValueMap.keySet().toArray(new String[0]);
    }

    @Override
    public boolean hasParameter(String name) {
        return this.parameterValueMap.containsKey(name) || this.structureFixed && this.altParameterValueMap.containsKey(name);
    }

    @Override
    public boolean hasParameter(ParameterKey key) {
        this.checkKey(key);
        return this.hasParameter(key.getName());
    }

    @Override
    public boolean isAssigned(String name) {
        ParameterValue p = this.getParameterValue(name);
        return p != null && p.isAssigned();
    }

    @Override
    public boolean isAssigned(ParameterKey key) {
        this.checkKey(key);
        return this.isAssigned(key.getName());
    }

    @Override
    public boolean hasValue(String name) {
        ParameterValue p = this.getParameterValue(name);
        return p != null && p.hasValue();
    }

    @Override
    public boolean hasValue(ParameterKey key) {
        this.checkKey(key);
        return this.hasValue(key.getName());
    }

    @Override
    public Parameter getParameter(String name) {
        ParameterValue p = this.getParameterValue(name);
        if (p == null && this.structureFixed) {
            throw new UnknownParameterException(name, this);
        }
        return p;
    }

    @Override
    public Parameter getParameter(ParameterKey key) {
        this.checkKey(key);
        return this.getParameter(key.getName());
    }

    @Override
    public Object getValue(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValue() : null;
    }

    @Override
    public Object getValue(ParameterKey key) {
        this.checkKey(key);
        return this.getValue(key.getName());
    }

    @Override
    public void putAll(Parameters parameters) {
        Assert.notNull((Object)parameters, "parameters must not be null");
        if (this.structureFixed) {
            throw new IllegalStateException("Not allowed in fixed structures");
        }
        for (ParameterValue parameterValue : parameters.getParameterValues()) {
            parameterValue.setContainer(this);
            this.parameterValueMap.put(parameterValue.getName(), parameterValue);
        }
    }

    @Override
    public void putValue(String name, Object value) {
        this.putValue(name, value, false);
    }

    @Override
    public void putValue(ParameterKey key, Object value) {
        this.checkKey(key);
        this.putValue(key.getName(), value);
    }

    @Override
    public void putValueIfNotNull(String name, Object value) {
        this.putValue(name, value, true);
    }

    @Override
    public void putValueIfNotNull(ParameterKey key, Object value) {
        this.checkKey(key);
        this.putValueIfNotNull(key.getName(), value);
    }

    private void putValue(String name, Object value, boolean notNullOnly) {
        if (value == null && notNullOnly) {
            return;
        }
        if (value != null && value.getClass().isArray()) {
            int len = Array.getLength(value);
            int affected = 0;
            for (int i = 0; i < len; ++i) {
                Object obj = Array.get(value, i);
                if (obj == null && notNullOnly) continue;
                this.putArrayValue(name, obj);
                ++affected;
            }
            if (affected == 0 && !notNullOnly) {
                this.putArrayValue(name, null);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            int affected = 0;
            for (Object obj : collection) {
                if (obj == null && notNullOnly) continue;
                this.putArrayValue(name, obj);
                ++affected;
            }
            if (affected == 0 && !notNullOnly) {
                this.putArrayValue(name, null);
            }
        } else if (value instanceof Iterator) {
            Iterator iterator = (Iterator)value;
            int affected = 0;
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (obj == null && notNullOnly) continue;
                this.putArrayValue(name, obj);
                ++affected;
            }
            if (affected == 0 && !notNullOnly) {
                this.putArrayValue(name, null);
            }
        } else if (value instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)value;
            int affected = 0;
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                if (obj == null && notNullOnly) continue;
                this.putArrayValue(name, obj);
                ++affected;
            }
            if (affected == 0 && !notNullOnly) {
                this.putArrayValue(name, null);
            }
        } else if (value instanceof Map) {
            Map map = (Map)value;
            int affected = 0;
            Object ps = this.touchParameters(name);
            for (Map.Entry entry : map.entrySet()) {
                Object obj = entry.getValue();
                if (obj == null && notNullOnly) continue;
                ps.putValue(entry.getKey().toString(), obj);
                ++affected;
            }
            if (affected == 0) {
                if (notNullOnly) {
                    this.removeValue(name);
                } else {
                    this.putValue(name, null, false);
                }
            }
        } else {
            Parameter p = this.getParameter(name);
            if (p == null) {
                ValueType valueType = ValueType.resolveFrom(value);
                p = this.newParameterValue(name, valueType);
            }
            this.putValue(p, name, value);
        }
    }

    private void putArrayValue(String name, Object value) {
        Parameter p = this.getParameter(name);
        if (p == null) {
            ValueType valueType = ValueType.resolveFrom(value);
            p = this.newParameterValue(name, valueType, true);
        }
        this.checkArrayType(p);
        if (value != null && value.getClass().isArray()) {
            this.putValue(p, name, value.toString());
        } else {
            this.putValue(p, name, value);
        }
    }

    private void putValue(@NonNull Parameter p, String name, Object value) {
        p.putValue(value);
        if (value instanceof Parameters) {
            Parameters parameters = (Parameters)value;
            parameters.setActualName(name);
            parameters.updateContainer(this);
        }
    }

    @Override
    public void removeValue(String name) {
        Assert.notNull((Object)name, "name must not be null");
        if (this.structureFixed) {
            Parameter p = this.getParameter(name);
            if (p != null) {
                p.removeValue();
            }
        } else {
            this.parameterValueMap.remove(name);
        }
    }

    @Override
    public void removeValue(ParameterKey key) {
        this.checkKey(key);
        this.removeValue(key.getName());
    }

    @Override
    public String getString(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsString() : null;
    }

    @Override
    public String getString(String name, String defaultValue) {
        String s = this.getString(name);
        return s != null ? s : defaultValue;
    }

    @Override
    public String getString(ParameterKey key) {
        this.checkKey(key);
        return this.getString(key.getName());
    }

    @Override
    public String getString(ParameterKey key, String defaultValue) {
        this.checkKey(key);
        return this.getString(key.getName(), defaultValue);
    }

    @Override
    public String[] getStringArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsStringArray() : null;
    }

    @Override
    public String[] getStringArray(ParameterKey key) {
        this.checkKey(key);
        return this.getStringArray(key.getName());
    }

    @Override
    public List<String> getStringList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsStringList() : null;
    }

    @Override
    public List<String> getStringList(ParameterKey key) {
        this.checkKey(key);
        return this.getStringList(key.getName());
    }

    @Override
    public Integer getInt(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsInt() : null;
    }

    @Override
    public int getInt(String name, int defaultValue) {
        Parameter p = this.getParameter(name);
        if (p != null) {
            Integer val = p.getValueAsInt();
            return val != null ? val : defaultValue;
        }
        return defaultValue;
    }

    @Override
    public Integer[] getIntArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsIntArray() : null;
    }

    @Override
    public Integer getInt(ParameterKey key) {
        this.checkKey(key);
        return this.getInt(key.getName());
    }

    @Override
    public int getInt(ParameterKey key, int defaultValue) {
        this.checkKey(key);
        return this.getInt(key.getName(), defaultValue);
    }

    @Override
    public Integer[] getIntArray(ParameterKey key) {
        this.checkKey(key);
        return this.getIntArray(key.getName());
    }

    @Override
    public List<Integer> getIntList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsIntList() : null;
    }

    @Override
    public List<Integer> getIntList(ParameterKey key) {
        this.checkKey(key);
        return this.getIntList(key.getName());
    }

    @Override
    public Long getLong(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsLong() : null;
    }

    @Override
    public long getLong(String name, long defaultValue) {
        Parameter p = this.getParameter(name);
        if (p != null) {
            Long val = p.getValueAsLong();
            return val != null ? val : defaultValue;
        }
        return defaultValue;
    }

    @Override
    public Long getLong(ParameterKey key) {
        this.checkKey(key);
        return this.getLong(key.getName());
    }

    @Override
    public long getLong(ParameterKey key, long defaultValue) {
        this.checkKey(key);
        return this.getLong(key.getName(), defaultValue);
    }

    @Override
    public Long[] getLongArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsLongArray() : null;
    }

    @Override
    public Long[] getLongArray(ParameterKey key) {
        this.checkKey(key);
        return this.getLongArray(key.getName());
    }

    @Override
    public List<Long> getLongList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsLongList() : null;
    }

    @Override
    public List<Long> getLongList(ParameterKey key) {
        this.checkKey(key);
        return this.getLongList(key.getName());
    }

    @Override
    public Float getFloat(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsFloat() : null;
    }

    @Override
    public float getFloat(String name, float defaultValue) {
        Parameter p = this.getParameter(name);
        if (p != null) {
            Float val = p.getValueAsFloat();
            return val != null ? val.floatValue() : defaultValue;
        }
        return defaultValue;
    }

    @Override
    public Float getFloat(ParameterKey key) {
        this.checkKey(key);
        return this.getFloat(key.getName());
    }

    @Override
    public float getFloat(ParameterKey key, float defaultValue) {
        this.checkKey(key);
        return this.getFloat(key.getName(), defaultValue);
    }

    @Override
    public Float[] getFloatArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsFloatArray() : null;
    }

    @Override
    public Float[] getFloatArray(ParameterKey key) {
        this.checkKey(key);
        return this.getFloatArray(key.getName());
    }

    @Override
    public List<Float> getFloatList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsFloatList() : null;
    }

    @Override
    public List<Float> getFloatList(ParameterKey key) {
        this.checkKey(key);
        return this.getFloatList(key.getName());
    }

    @Override
    public Double getDouble(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsDouble() : null;
    }

    @Override
    public double getDouble(String name, double defaultValue) {
        Parameter p = this.getParameter(name);
        if (p != null) {
            Double val = p.getValueAsDouble();
            return val != null ? val : defaultValue;
        }
        return defaultValue;
    }

    @Override
    public Double getDouble(ParameterKey key) {
        this.checkKey(key);
        return this.getDouble(key.getName());
    }

    @Override
    public double getDouble(ParameterKey key, double defaultValue) {
        this.checkKey(key);
        return this.getDouble(key.getName(), defaultValue);
    }

    @Override
    public Double[] getDoubleArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsDoubleArray() : null;
    }

    @Override
    public Double[] getDoubleArray(ParameterKey key) {
        this.checkKey(key);
        return this.getDoubleArray(key.getName());
    }

    @Override
    public List<Double> getDoubleList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsDoubleList() : null;
    }

    @Override
    public List<Double> getDoubleList(ParameterKey key) {
        this.checkKey(key);
        return this.getDoubleList(key.getName());
    }

    @Override
    public Boolean getBoolean(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsBoolean() : null;
    }

    @Override
    public boolean getBoolean(String name, boolean defaultValue) {
        Parameter p = this.getParameter(name);
        return p != null ? BooleanUtils.toBoolean(p.getValueAsBoolean(), defaultValue) : defaultValue;
    }

    @Override
    public Boolean getBoolean(ParameterKey key) {
        this.checkKey(key);
        return this.getBoolean(key.getName());
    }

    @Override
    public boolean getBoolean(ParameterKey key, boolean defaultValue) {
        this.checkKey(key);
        return this.getBoolean(key.getName(), defaultValue);
    }

    @Override
    public Boolean[] getBooleanArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsBooleanArray() : null;
    }

    @Override
    public Boolean[] getBooleanArray(ParameterKey key) {
        this.checkKey(key);
        return this.getBooleanArray(key.getName());
    }

    @Override
    public List<Boolean> getBooleanList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsBooleanList() : null;
    }

    @Override
    public List<Boolean> getBooleanList(ParameterKey key) {
        this.checkKey(key);
        return this.getBooleanList(key.getName());
    }

    @Override
    public <T extends Parameters> T getParameters(String name) {
        Parameter p = this.getParameter(name);
        return (T)(p != null ? p.getValueAsParameters() : null);
    }

    @Override
    public <T extends Parameters> T getParameters(ParameterKey key) {
        this.checkKey(key);
        return this.getParameters(key.getName());
    }

    @Override
    public <T extends Parameters> T[] getParametersArray(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsParametersArray() : null;
    }

    @Override
    public <T extends Parameters> T[] getParametersArray(ParameterKey key) {
        this.checkKey(key);
        return this.getParametersArray(key.getName());
    }

    @Override
    public <T extends Parameters> List<T> getParametersList(String name) {
        Parameter p = this.getParameter(name);
        return p != null ? p.getValueAsParametersList() : null;
    }

    @Override
    public <T extends Parameters> List<T> getParametersList(ParameterKey key) {
        this.checkKey(key);
        return this.getParametersList(key.getName());
    }

    @Override
    public ParameterValue newParameterValue(String name, ValueType valueType) {
        return this.newParameterValue(name, valueType, false);
    }

    @Override
    public ParameterValue newParameterValue(String name, ValueType valueType, boolean array) {
        Assert.state(!this.structureFixed, "Unknown parameter: " + name);
        ParameterValue pv = new ParameterValue(name, valueType, array);
        pv.setContainer(this);
        this.parameterValueMap.put(name, pv);
        return pv;
    }

    @Override
    public <T extends Parameters> T newParameters(String name) {
        Parameter p = this.getParameter(name);
        if (this.structureFixed) {
            if (p == null) {
                throw new UnknownParameterException(name, this);
            }
        } else if (p == null) {
            p = this.newParameterValue(name, ValueType.PARAMETERS);
        }
        Object ps = p.newParameters(p);
        ps.setActualName(name);
        return ps;
    }

    @Override
    public <T extends Parameters> T newParameters(ParameterKey key) {
        this.checkKey(key);
        return this.newParameters(key.getName());
    }

    @Override
    public <T extends Parameters> T touchParameters(String name) {
        T parameters = this.getParameters(name);
        if (parameters == null) {
            parameters = this.newParameters(name);
        }
        return parameters;
    }

    @Override
    public <T extends Parameters> T touchParameters(ParameterKey key) {
        this.checkKey(key);
        return this.touchParameters(key.getName());
    }

    @Override
    public void updateContainer(@NonNull Parameters container) {
        for (ParameterValue parameterValue : container.getParameterValues()) {
            parameterValue.setContainer(container);
        }
    }

    @Override
    public void readFrom(String apon) throws AponParseException {
        if (apon != null) {
            AponReader.read(apon, this);
        }
    }

    @Override
    public void readFrom(VariableParameters parameters) throws AponParseException {
        if (parameters != null) {
            this.readFrom(parameters.toString());
        }
    }

    @Override
    public void readFrom(File file) throws AponParseException {
        if (file != null) {
            AponReader.read(file, this);
        }
    }

    @Override
    public void readFrom(File file, String encoding) throws AponParseException {
        if (file != null) {
            AponReader.read(file, encoding, this);
        }
    }

    @Override
    public void readFrom(Reader reader) throws AponParseException {
        if (reader != null) {
            AponReader.read(reader, this);
        }
    }

    @Override
    public <T extends Parameters> T copy() {
        try {
            Parameters parameters = (Parameters)ClassUtils.createInstance(this.getClass());
            parameters.readFrom(this.toString());
            return (T)parameters;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to copy " + ObjectUtils.identityToString(this), e);
        }
    }

    @Override
    public String describe() {
        return this.describe(false);
    }

    @Override
    public String describe(boolean details) {
        ToStringBuilder tsb = new ToStringBuilder();
        tsb.append("qualifiedName", this.getQualifiedName());
        if (details) {
            tsb.append("parameters", this.parameterValueMap);
            if (this.structureFixed && !this.altParameterValueMap.isEmpty()) {
                tsb.append("altParameters", this.altParameterValueMap);
            }
        } else {
            tsb.append("parameters", this.getParameterNames());
        }
        tsb.append("class", this.getClass().getName());
        tsb.append("parent", this.getParent());
        return tsb.toString();
    }

    public String toString() {
        try {
            return ((AponWriter)((AponWriter)new AponWriter().nullWritable(false)).write(this)).toString();
        }
        catch (IOException e) {
            return "";
        }
    }

    private void checkKey(ParameterKey key) {
        Assert.notNull((Object)key, "key must not be null");
    }

    private void checkArrayType(Parameter parameter) {
        if (this.structureFixed && !parameter.isArray()) {
            throw new IllegalArgumentException("Not an array type parameter: " + String.valueOf(parameter));
        }
    }
}

