/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.apon;

import com.aspectran.utils.ArrayStack;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.apon.AponFormat;
import com.aspectran.utils.apon.AponParseException;
import com.aspectran.utils.apon.AponReader;
import java.util.Arrays;

public class AponLines
extends AponFormat {
    private final StringBuilder lines = new StringBuilder();
    private final ArrayStack<State> stateStack = new ArrayStack();

    public AponLines() {
        this.block();
    }

    public AponLines line(String line) {
        if (this.stateStack.isEmpty()) {
            this.checkState(State.BLOCK);
        }
        if (line != null) {
            if (this.stateStack.peek() == State.TEXT) {
                this.lines.append('|');
            }
            this.lines.append(line).append("\n");
        }
        return this;
    }

    public AponLines line(String name, Object value) {
        this.checkName(name);
        this.checkState(State.BLOCK);
        if (value != null) {
            this.lines.append(name).append(':').append(" ").append(value).append("\n");
        }
        return this;
    }

    public AponLines block(String name) {
        this.checkName(name);
        this.checkState(State.BLOCK);
        this.stateStack.push(State.BLOCK);
        this.lines.append(name).append(':').append(" ").append('{').append("\n");
        return this;
    }

    public AponLines block() {
        if (this.stateStack.isEmpty()) {
            this.stateStack.push(State.BLOCK);
        } else {
            this.checkState(State.ARRAY);
            this.stateStack.push(State.BLOCK);
            this.lines.append('{').append("\n");
        }
        return this;
    }

    public AponLines array(String name) {
        this.checkName(name);
        this.checkState(State.BLOCK);
        this.stateStack.push(State.ARRAY);
        this.lines.append(name).append(':').append(" ").append('[').append("\n");
        return this;
    }

    public AponLines array() {
        this.checkState(State.ARRAY);
        this.stateStack.push(State.ARRAY);
        this.lines.append('[').append("\n");
        return this;
    }

    public AponLines text(String name) {
        this.checkName(name);
        this.checkState(State.BLOCK);
        this.stateStack.push(State.TEXT);
        this.lines.append(name).append(':').append(" ").append('(').append("\n");
        return this;
    }

    public AponLines text() {
        this.checkState(State.ARRAY);
        this.stateStack.push(State.TEXT);
        this.lines.append('(').append("\n");
        return this;
    }

    public AponLines end() {
        if (this.stateStack.isEmpty()) {
            this.checkState(State.BLOCK);
        }
        State state = this.stateStack.pop();
        switch (state.ordinal()) {
            case 0: {
                if (this.stateStack.isEmpty()) break;
                this.lines.append('}').append("\n");
                break;
            }
            case 1: {
                this.lines.append(']').append("\n");
                break;
            }
            case 2: {
                this.lines.append(')').append("\n");
                break;
            }
            default: {
                throw new IllegalStateException("Must be one of these states: " + Arrays.toString((Object[])State.values()));
            }
        }
        return this;
    }

    public String toString() {
        return this.lines.toString();
    }

    public String format() throws AponParseException {
        return AponReader.read(this.toString()).toString();
    }

    private void checkName(String name) {
        if (!StringUtils.hasText(name)) {
            throw new IllegalArgumentException("Invalid name: " + name);
        }
    }

    private void checkState(State required) {
        if (this.stateStack.isEmpty() || this.stateStack.peek() != required) {
            throw new IllegalStateException("Required state: " + String.valueOf((Object)required));
        }
    }

    private static enum State {
        BLOCK,
        ARRAY,
        TEXT;

    }
}

