/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.apon;

import com.aspectran.utils.Assert;
import com.aspectran.utils.ClassUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.ArrayParameters;
import com.aspectran.utils.apon.Parameter;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.apon.ValueType;
import com.aspectran.utils.apon.VariableParameters;
import com.aspectran.utils.json.JsonReader;
import com.aspectran.utils.json.JsonReaderCloseable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class JsonToParameters {
    private final Class<? extends Parameters> requiredType;

    public JsonToParameters() {
        this.requiredType = null;
    }

    public JsonToParameters(Class<? extends Parameters> requiredType) {
        Assert.notNull(requiredType, "requiredType must not be null");
        this.requiredType = requiredType;
    }

    public <T extends Parameters> T read(String json) throws IOException {
        T container = this.createContainer();
        return this.read(json, container);
    }

    public <T extends Parameters> T read(String json, T container) throws IOException {
        Assert.notNull((Object)json, "json must not be null");
        this.read(new StringReader(json), container);
        return container;
    }

    public <T extends Parameters> T read(Reader reader) throws IOException {
        T container = this.createContainer();
        return this.read(reader, container);
    }

    public <T extends Parameters> T read(Reader reader, T container) throws IOException {
        Assert.notNull((Object)reader, "reader must not be null");
        Assert.notNull(container, "container must not be null");
        String name = container instanceof ArrayParameters ? "<noname>" : null;
        try (JsonReaderCloseable jsonReader = new JsonReaderCloseable(reader);){
            this.read(jsonReader, container, name);
        }
        catch (Exception e) {
            throw new IOException("Failed to convert JSON to APON", e);
        }
        return container;
    }

    @NonNull
    private <T extends Parameters> T createContainer() {
        Parameters container = this.requiredType != null ? ClassUtils.createInstance(this.requiredType) : new VariableParameters();
        return (T)container;
    }

    private void read(@NonNull JsonReader reader, Parameters container, String name) throws IOException {
        switch (reader.peek()) {
            case BEGIN_OBJECT: {
                reader.beginObject();
                if (name != null) {
                    container = container.newParameters(name);
                }
                while (reader.hasNext()) {
                    this.read(reader, container, reader.nextName());
                }
                reader.endObject();
                return;
            }
            case BEGIN_ARRAY: {
                reader.beginArray();
                while (reader.hasNext()) {
                    this.read(reader, container, name);
                }
                reader.endArray();
                return;
            }
            case STRING: {
                container.putValue(name, (Object)reader.nextString());
                return;
            }
            case BOOLEAN: {
                container.putValue(name, (Object)reader.nextBoolean());
                return;
            }
            case NUMBER: {
                try {
                    container.putValue(name, (Object)reader.nextInt());
                }
                catch (NumberFormatException e0) {
                    try {
                        container.putValue(name, (Object)reader.nextLong());
                    }
                    catch (NumberFormatException e1) {
                        container.putValue(name, (Object)reader.nextDouble());
                    }
                }
                return;
            }
            case NULL: {
                reader.nextNull();
                Parameter parameter = container.getParameter(name);
                if (parameter == null || parameter.getValueType() != ValueType.PARAMETERS) {
                    container.putValue(name, null);
                }
                return;
            }
        }
        throw new IllegalStateException();
    }

    @NonNull
    public static Parameters from(String json) throws IOException {
        return new JsonToParameters().read(json);
    }

    @NonNull
    public static <T extends Parameters> T from(String json, Class<? extends Parameters> requiredType) throws IOException {
        return new JsonToParameters(requiredType).read(json);
    }

    @NonNull
    public static Parameters from(Reader reader) throws IOException {
        return new JsonToParameters().read(reader);
    }

    @NonNull
    public static <T extends Parameters> T from(Reader reader, Class<? extends Parameters> requiredType) throws IOException {
        return new JsonToParameters(requiredType).read(reader);
    }
}

