/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.apon;

import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.AponParseException;
import com.aspectran.utils.apon.ParameterValue;
import com.aspectran.utils.apon.ValueType;

public class MalformedAponException
extends AponParseException {
    private static final long serialVersionUID = -2012813522496665651L;

    public MalformedAponException(String msg) {
        super(msg);
    }

    public MalformedAponException(int lineNumber, String line, String tline, String msg) {
        super(MalformedAponException.makeMessage(lineNumber, line, tline, msg));
    }

    public MalformedAponException(int lineNumber, String line, String tline, ParameterValue parameterValue, ValueType expectedValueType) {
        super(MalformedAponException.makeMessage(lineNumber, line, tline, parameterValue, expectedValueType));
    }

    @NonNull
    private static String makeMessage(int lineNumber, String line, String tline, String msg) {
        int columnNumber = tline != null ? line.indexOf((String)tline) : 0;
        StringBuilder sb = new StringBuilder();
        if (msg != null) {
            sb.append(msg);
        }
        sb.append(" [lineNumber: ").append(lineNumber);
        if (columnNumber != -1) {
            String lspace = line.substring(0, columnNumber);
            int tabCnt = StringUtils.search(lspace, "\t");
            if (tline != null && ((String)tline).length() > 33) {
                tline = ((String)tline).substring(0, 30) + "...";
            }
            sb.append(", columnNumber: ").append(columnNumber + 1);
            if (tabCnt != 0) {
                sb.append(" (");
                sb.append("Tabs ").append(tabCnt);
                sb.append(", Spaces ").append(columnNumber - tabCnt);
                sb.append(")");
            }
            sb.append("] ").append((String)tline);
        }
        return sb.toString();
    }

    @NonNull
    private static String makeMessage(int lineNumber, String line, String tline, ParameterValue parameterValue, ValueType expectedValueType) {
        StringBuilder sb = new StringBuilder();
        sb.append("Incompatible value type with expected value type '");
        sb.append((Object)expectedValueType).append("'");
        if (parameterValue != null) {
            sb.append(" for the specified parameter ").append(parameterValue);
        }
        return MalformedAponException.makeMessage(lineNumber, line, tline, sb.toString());
    }
}

