/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.apon;

import com.aspectran.utils.Assert;
import com.aspectran.utils.BeanUtils;
import com.aspectran.utils.ClassUtils;
import com.aspectran.utils.ObjectUtils;
import com.aspectran.utils.StringifyContext;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.apon.InvalidParameterValueException;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.apon.VariableParameters;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public class ObjectToParameters {
    private final Class<? extends Parameters> requiredType;
    private StringifyContext stringifyContext;

    public ObjectToParameters() {
        this.requiredType = null;
    }

    public ObjectToParameters(Class<? extends Parameters> requiredType) {
        Assert.notNull(requiredType, "requiredType must not be null");
        this.requiredType = requiredType;
    }

    public void setStringifyContext(StringifyContext stringifyContext) {
        this.stringifyContext = stringifyContext;
    }

    public ObjectToParameters apply(StringifyContext stringifyContext) {
        this.setStringifyContext(stringifyContext);
        return this;
    }

    public <T extends Parameters> T read(Object object) {
        return this.createContainer(object);
    }

    public <T extends Parameters> T read(String name, Object object) {
        T container = this.createContainer();
        return this.read(name, object, container);
    }

    public <T extends Parameters> T read(String name, Object object, T container) {
        Assert.notNull((Object)name, "name must not be null");
        Assert.notNull(object, "object must not be null");
        Assert.notNull(container, "container must not be null");
        this.putValue(container, name, object);
        return container;
    }

    @NonNull
    private <T extends Parameters> T createContainer() {
        Parameters container = this.requiredType != null ? ClassUtils.createInstance(this.requiredType) : new VariableParameters();
        return (T)container;
    }

    @NonNull
    protected <T extends Parameters> T createContainer(Object object) {
        Assert.notNull(object, "object must not be null");
        if (object instanceof Map) {
            Map map = (Map)object;
            T ps = this.createContainer();
            for (Map.Entry entry : map.entrySet()) {
                String name = entry.getKey().toString();
                Object value = entry.getValue();
                this.checkCircularReference(map, value);
                this.putValue((Parameters)ps, name, value);
            }
            return ps;
        }
        return this.createContainer();
    }

    protected void putValue(@NonNull Parameters container, @NonNull String name, Object value) {
        if (this.isNullWritable()) {
            container.putValue(name, this.normalize(value));
        } else {
            container.putValueIfNotNull(name, this.normalize(value));
        }
    }

    protected void putValue(@NonNull Parameters container, Object value) {
        Object obj = this.normalize(value);
        if (obj instanceof Parameters) {
            Parameters parameters = (Parameters)obj;
            container.putAll(parameters);
        }
    }

    private Object normalize(Object object) {
        if (object == null || object instanceof Parameters || object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Character || object instanceof Collection || object instanceof Iterator || object instanceof Enumeration || object.getClass().isArray()) {
            return object;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            VariableParameters ps = new VariableParameters();
            for (Map.Entry entry : map.entrySet()) {
                String name = entry.getKey().toString();
                Object value = entry.getValue();
                this.checkCircularReference(map, value);
                this.putValue(ps, name, value);
            }
            return ps;
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            if (this.stringifyContext != null) {
                return this.stringifyContext.toString(localDateTime);
            }
            return localDateTime.toString();
        }
        if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            if (this.stringifyContext != null) {
                return this.stringifyContext.toString(localDate);
            }
            return localDate.toString();
        }
        if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            if (this.stringifyContext != null) {
                return this.stringifyContext.toString(localTime);
            }
            return localTime.toString();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            if (this.stringifyContext != null) {
                return this.stringifyContext.toString(date);
            }
            return date.toString();
        }
        String[] readablePropertyNames = BeanUtils.getReadablePropertyNamesWithoutNonSerializable(object);
        if (readablePropertyNames != null && readablePropertyNames.length > 0) {
            VariableParameters ps = new VariableParameters();
            for (String name : readablePropertyNames) {
                Object value;
                try {
                    value = BeanUtils.getProperty(object, name);
                }
                catch (InvocationTargetException e) {
                    throw new InvalidParameterValueException(e);
                }
                this.checkCircularReference(object, value);
                this.putValue(ps, name, value);
            }
            return ps;
        }
        return object.toString();
    }

    private boolean isNullWritable() {
        return this.stringifyContext == null || this.stringifyContext.isNullWritable();
    }

    private void checkCircularReference(@NonNull Object wrapper, Object member) {
        if (wrapper == member) {
            throw new IllegalArgumentException("Serialization Failure: Circular reference was detected while serializing object " + ObjectUtils.identityToString(wrapper) + " " + String.valueOf(wrapper));
        }
    }

    @NonNull
    public static Parameters from(Object object) throws IOException {
        return new ObjectToParameters().read(object);
    }

    @NonNull
    public static Parameters from(Object object, StringifyContext stringifyContext) throws IOException {
        return new ObjectToParameters().apply(stringifyContext).read(object);
    }

    @NonNull
    public static <T extends Parameters> T from(Object object, Class<? extends Parameters> requiredType) throws IOException {
        return new ObjectToParameters(requiredType).read(object);
    }

    @NonNull
    public static <T extends Parameters> T from(Object object, Class<? extends Parameters> requiredType, StringifyContext stringifyContext) throws IOException {
        return new ObjectToParameters(requiredType).apply(stringifyContext).read(object);
    }

    @NonNull
    public static Parameters from(String name, Object object) throws IOException {
        return new ObjectToParameters().read(name, object);
    }

    @NonNull
    public static Parameters from(String name, Object object, StringifyContext stringifyContext) throws IOException {
        return new ObjectToParameters().apply(stringifyContext).read(name, object);
    }

    @NonNull
    public static <T extends Parameters> T from(String name, Object object, Class<? extends Parameters> requiredType) throws IOException {
        return new ObjectToParameters(requiredType).read(name, object);
    }

    @NonNull
    public static <T extends Parameters> T from(String name, Object object, Class<? extends Parameters> requiredType, StringifyContext stringifyContext) throws IOException {
        return new ObjectToParameters(requiredType).apply(stringifyContext).read(name, object);
    }
}

