/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.apon;

import com.aspectran.utils.Assert;
import com.aspectran.utils.ClassUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.Parameter;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.apon.ValueType;
import com.aspectran.utils.apon.VariableParameters;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToParameters {
    private final Class<? extends Parameters> requiredType;
    private final EntityResolver entityResolver;

    public XmlToParameters() {
        this.requiredType = null;
        this.entityResolver = null;
    }

    public XmlToParameters(Class<? extends Parameters> requiredType) {
        Assert.notNull(requiredType, "requiredType must not be null");
        this.requiredType = requiredType;
        this.entityResolver = null;
    }

    public XmlToParameters(Class<? extends Parameters> requiredType, EntityResolver entityResolver) {
        Assert.notNull(requiredType, "requiredType must not be null");
        Assert.notNull((Object)entityResolver, "entityResolver must not be null");
        this.requiredType = requiredType;
        this.entityResolver = entityResolver;
    }

    @NonNull
    public <T extends Parameters> T read(String xml) throws IOException {
        T container = this.createContainer();
        return this.read(xml, container);
    }

    @NonNull
    public <T extends Parameters> T read(String xml, T container) throws IOException {
        Assert.notNull((Object)xml, "xml must not be null");
        this.read(new StringReader(xml), container);
        return container;
    }

    @NonNull
    public <T extends Parameters> T read(Reader reader) throws IOException {
        T container = this.createContainer();
        return this.read(reader, container);
    }

    @NonNull
    public <T extends Parameters> T read(Reader reader, T container) throws IOException {
        Assert.notNull((Object)reader, "reader must not be null");
        return this.read(new InputSource(reader), container);
    }

    @NonNull
    public <T extends Parameters> T read(InputStream inputStream) throws IOException {
        T container = this.createContainer();
        return this.read(inputStream, container);
    }

    @NonNull
    public <T extends Parameters> T read(InputStream inputStream, T container) throws IOException {
        Assert.notNull((Object)inputStream, "inputStream must not be null");
        return this.read(new InputSource(inputStream), container);
    }

    @NonNull
    public <T extends Parameters> T read(File file) throws IOException {
        T container = this.createContainer();
        return this.read(file, container);
    }

    @NonNull
    public <T extends Parameters> T read(File file, T container) throws IOException {
        Assert.notNull((Object)file, "file must not be null");
        InputSource inputSource = new InputSource(file.toURI().toASCIIString());
        return this.read(inputSource, container);
    }

    @NonNull
    public <T extends Parameters> T read(InputSource inputSource) throws IOException {
        T container = this.createContainer();
        return this.read(inputSource, container);
    }

    @NonNull
    public <T extends Parameters> T read(InputSource inputSource, T container) throws IOException {
        Assert.notNull((Object)inputSource, "inputSource must not be null");
        Assert.notNull(container, "container must not be null");
        ParameterValueHandler valueHandler = null;
        try {
            valueHandler = new ParameterValueHandler(container);
            if (this.entityResolver != null) {
                valueHandler.setEntityResolver(this.entityResolver);
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(inputSource, (DefaultHandler)valueHandler);
        }
        catch (Exception e) {
            String location = this.getLocation(valueHandler);
            throw new IOException("Failed to convert XML to APON " + location + "; " + e.getMessage(), e);
        }
        return container;
    }

    @NonNull
    private <T extends Parameters> T createContainer() {
        Parameters container = this.requiredType != null ? ClassUtils.createInstance(this.requiredType) : new VariableParameters();
        return (T)container;
    }

    private String getLocation(ParameterValueHandler valueHandler) {
        Object location;
        if (valueHandler != null && valueHandler.getLocator() != null) {
            Locator locator = valueHandler.getLocator();
            location = "Line Number " + locator.getLineNumber() + ", Column " + locator.getColumnNumber();
            location = locator.getSystemId() != null ? "; " + locator.getSystemId() + " " + (String)location : "; " + (String)location;
        } else {
            location = "";
        }
        return location;
    }

    @NonNull
    public static Parameters from(String xml) throws IOException {
        return new XmlToParameters().read(xml);
    }

    @NonNull
    public static <T extends Parameters> T from(String xml, Class<? extends Parameters> requiredType) throws IOException {
        return new XmlToParameters(requiredType).read(xml);
    }

    @NonNull
    public static <T extends Parameters> T from(String xml, Class<? extends Parameters> requiredType, EntityResolver entityResolver) throws IOException {
        return new XmlToParameters(requiredType, entityResolver).read(xml);
    }

    @NonNull
    public static Parameters from(Reader reader) throws IOException {
        return new XmlToParameters().read(reader);
    }

    @NonNull
    public static <T extends Parameters> T from(Reader reader, Class<? extends Parameters> requiredType) throws IOException {
        return new XmlToParameters(requiredType).read(reader);
    }

    @NonNull
    public static <T extends Parameters> T from(Reader reader, Class<? extends Parameters> requiredType, EntityResolver entityResolver) throws IOException {
        return new XmlToParameters(requiredType, entityResolver).read(reader);
    }

    @NonNull
    public static Parameters from(InputStream inputStream) throws IOException {
        return new XmlToParameters().read(inputStream);
    }

    @NonNull
    public static <T extends Parameters> T from(InputStream inputStream, Class<? extends Parameters> requiredType) throws IOException {
        return new XmlToParameters(requiredType).read(inputStream);
    }

    @NonNull
    public static <T extends Parameters> T from(InputStream inputStream, Class<? extends Parameters> requiredType, EntityResolver entityResolver) throws IOException {
        return new XmlToParameters(requiredType, entityResolver).read(inputStream);
    }

    @NonNull
    public static Parameters from(File file) throws IOException {
        return new XmlToParameters().read(file);
    }

    @NonNull
    public static <T extends Parameters> T from(File file, Class<? extends Parameters> requiredType) throws IOException {
        return new XmlToParameters(requiredType).read(file);
    }

    @NonNull
    public static <T extends Parameters> T from(File file, Class<? extends Parameters> requiredType, EntityResolver entityResolver) throws IOException {
        return new XmlToParameters(requiredType, entityResolver).read(file);
    }

    @NonNull
    public static Parameters from(InputSource inputSource) throws IOException {
        return new XmlToParameters().read(inputSource);
    }

    @NonNull
    public static <T extends Parameters> T from(InputSource inputSource, Class<? extends Parameters> requiredType) throws IOException {
        return new XmlToParameters(requiredType).read(inputSource);
    }

    @NonNull
    public static <T extends Parameters> T from(InputSource inputSource, Class<? extends Parameters> requiredType, EntityResolver entityResolver) throws IOException {
        return new XmlToParameters(requiredType, entityResolver).read(inputSource);
    }

    private static class ParameterValueHandler
    extends DefaultHandler {
        private final StringBuilder buffer = new StringBuilder();
        private Parameters parameters;
        private EntityResolver entityResolver;
        private String name;
        private boolean open;
        private boolean leaf;
        private Locator locator;

        public ParameterValueHandler(Parameters container) {
            this.parameters = container;
        }

        public void setEntityResolver(EntityResolver entityResolver) {
            this.entityResolver = entityResolver;
        }

        @Override
        @Nullable
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            if (this.entityResolver != null) {
                return this.entityResolver.resolveEntity(publicId, systemId);
            }
            return null;
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (this.name != null) {
                this.parameters = this.parameters.newParameters(this.name);
                this.leaf = false;
            }
            Parameter p = this.parameters.getParameter(qName);
            if (attributes != null && attributes.getLength() > 0 || p != null && p.getValueType() == ValueType.PARAMETERS) {
                this.parameters = this.parameters.newParameters(qName);
                if (attributes != null) {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        this.parameters.putValue(attributes.getQName(i), (Object)attributes.getValue(i));
                    }
                }
                this.name = null;
                this.leaf = false;
            } else {
                this.name = qName;
                this.leaf = true;
            }
            this.open = true;
            if (!this.buffer.isEmpty()) {
                this.buffer.delete(0, this.buffer.length());
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.open) {
                String text = null;
                if (!this.buffer.isEmpty()) {
                    text = this.buffer.toString();
                    this.buffer.delete(0, this.buffer.length());
                }
                if (text != null) {
                    this.parameters.putValue(qName, (Object)text);
                }
                this.name = null;
                this.open = false;
            }
            if (!this.leaf) {
                this.parameters = this.parameters.getProprietor().getContainer();
            } else {
                this.leaf = false;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.buffer.append(ch, start, length);
        }

        public Locator getLocator() {
            return this.locator;
        }
    }
}

