/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.json;

import com.aspectran.utils.StringifyContext;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.json.JsonString;
import com.aspectran.utils.json.JsonWriter;
import java.io.IOException;
import java.io.StringWriter;

public class JsonBuilder {
    private final JsonWriter jsonWriter = new JsonWriter(new StringWriter());

    public void setStringifyContext(StringifyContext stringifyContext) {
        this.jsonWriter.setStringifyContext(stringifyContext);
    }

    public JsonBuilder apply(StringifyContext stringifyContext) {
        this.setStringifyContext(stringifyContext);
        return this;
    }

    public JsonBuilder prettyPrint(boolean prettyPrint) {
        this.jsonWriter.prettyPrint(prettyPrint);
        return this;
    }

    public JsonBuilder indentString(@Nullable String indentString) {
        this.jsonWriter.indentString(indentString);
        return this;
    }

    public JsonBuilder nullWritable(boolean nullWritable) {
        this.jsonWriter.nullWritable(nullWritable);
        return this;
    }

    public JsonBuilder object() {
        try {
            this.jsonWriter.beginObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public JsonBuilder object(String name) {
        try {
            ((JsonWriter)this.jsonWriter.name(name)).beginObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public JsonBuilder endObject() {
        try {
            this.jsonWriter.endObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public JsonBuilder array() {
        try {
            this.jsonWriter.beginArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public JsonBuilder array(String name) {
        try {
            ((JsonWriter)this.jsonWriter.name(name)).beginArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public JsonBuilder endArray() {
        try {
            this.jsonWriter.endArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public JsonBuilder put(Object value) {
        try {
            this.jsonWriter.value(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public JsonBuilder put(String name, Object value) {
        try {
            ((JsonWriter)this.jsonWriter.name(name)).value(value);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Nullable
    public String toString() {
        return this.jsonWriter.toString();
    }

    public JsonString toJsonString() {
        return new JsonString(this.jsonWriter.toString());
    }
}

