/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.json;

import com.aspectran.utils.ArrayStack;
import com.aspectran.utils.Assert;
import com.aspectran.utils.BeanUtils;
import com.aspectran.utils.StringifyContext;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.Parameter;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.json.JsonString;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;

public class JsonWriter {
    private static final String DEFAULT_INDENT_STRING = "  ";
    private static final String NULL_STRING = "null";
    private final ArrayStack<Boolean> writtenFlags = new ArrayStack();
    private final Writer writer;
    private StringifyContext stringifyContext;
    private boolean prettyPrint = true;
    private String indentString = "  ";
    private boolean nullWritable = true;
    private int indentDepth;
    private String pendedName;
    private Object upperObject;

    public JsonWriter(Writer writer) {
        Assert.notNull((Object)writer, "out must not be null");
        this.writer = writer;
        this.writtenFlags.push(false);
    }

    public void setStringifyContext(StringifyContext stringifyContext) {
        this.stringifyContext = stringifyContext;
        if (stringifyContext != null) {
            if (stringifyContext.hasPretty()) {
                this.prettyPrint(stringifyContext.isPretty());
            }
            if (stringifyContext.hasIndentSize()) {
                this.indentString(stringifyContext.getIndentString());
            }
            if (stringifyContext.hasNullWritable()) {
                this.nullWritable(stringifyContext.isNullWritable());
            }
        }
    }

    public <T extends JsonWriter> T apply(StringifyContext stringifyContext) {
        this.setStringifyContext(stringifyContext);
        return (T)this;
    }

    public <T extends JsonWriter> T prettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        if (prettyPrint) {
            if (this.indentString == null) {
                this.indentString = DEFAULT_INDENT_STRING;
            }
        } else {
            this.indentString = null;
        }
        return (T)this;
    }

    public <T extends JsonWriter> T indentString(@Nullable String indentString) {
        this.indentString = indentString;
        return (T)this;
    }

    public <T extends JsonWriter> T nullWritable(boolean nullWritable) {
        this.nullWritable = nullWritable;
        return (T)this;
    }

    public <T extends JsonWriter> T beginObject() throws IOException {
        this.writePendedName();
        this.writer.write("{");
        this.nextLine();
        ++this.indentDepth;
        this.writtenFlags.push(false);
        return (T)this;
    }

    public <T extends JsonWriter> T endObject() throws IOException {
        --this.indentDepth;
        if (this.writtenFlags.pop().booleanValue()) {
            this.nextLine();
        }
        this.indent();
        this.writer.write("}");
        this.writtenFlags.update(true);
        return (T)this;
    }

    public <T extends JsonWriter> T beginArray() throws IOException {
        this.writePendedName();
        this.writer.write("[");
        this.nextLine();
        ++this.indentDepth;
        this.writtenFlags.push(false);
        return (T)this;
    }

    public <T extends JsonWriter> T endArray() throws IOException {
        --this.indentDepth;
        if (this.writtenFlags.pop().booleanValue()) {
            this.nextLine();
        }
        this.indent();
        this.writer.write("]");
        this.writtenFlags.update(true);
        return (T)this;
    }

    public <T extends JsonWriter> T name(String name) throws IOException {
        this.writeName(name);
        return (T)this;
    }

    public <T extends JsonWriter> T value(Object value) throws IOException {
        this.writeValue(value);
        return (T)this;
    }

    public void writeName(String name) {
        this.pendedName = name;
    }

    private void writePendedName() throws IOException {
        if (this.writtenFlags.peek().booleanValue()) {
            this.writeComma();
        }
        if (this.pendedName != null) {
            this.indent();
            this.writer.write(JsonWriter.escape(this.pendedName));
            this.writer.write(":");
            if (this.prettyPrint) {
                this.writer.write(" ");
            }
            this.pendedName = null;
        } else {
            this.indent();
        }
    }

    private void clearPendedName() {
        this.pendedName = null;
    }

    /*
     * WARNING - void declaration
     */
    public void writeValue(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
        } else if (object instanceof String) {
            String string = (String)object;
            this.writeString(string);
        } else if (object instanceof JsonString) {
            this.writeJson(object.toString());
        } else if (object instanceof Character) {
            this.writeString(String.valueOf(object));
        } else if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            this.writeBool(bool);
        } else if (object instanceof Number) {
            Number number = (Number)object;
            this.writeNumber(number);
        } else if (object instanceof Parameters) {
            Parameters parameters = (Parameters)object;
            this.beginObject();
            for (Parameter parameter : parameters.getParameterValues()) {
                String name = parameter.getName();
                Object value = parameter.getValue();
                this.writeName(name);
                this.writeValue(value, object);
            }
            this.endObject();
        } else if (object instanceof Map) {
            Map map = (Map)object;
            this.beginObject();
            for (Map.Entry entry : map.entrySet()) {
                String name = entry.getKey().toString();
                Object value = entry.getValue();
                this.writeName(name);
                this.writeValue(value, object);
            }
            this.endObject();
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            this.beginArray();
            for (Object e : collection) {
                if (e != null) {
                    this.writeValue(e, object);
                    continue;
                }
                this.writeNull(true);
            }
            this.endArray();
        } else if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            this.beginArray();
            while (iterator.hasNext()) {
                Object value = iterator.next();
                if (value != null) {
                    this.writeValue(value, object);
                    continue;
                }
                this.writeNull(true);
            }
            this.endArray();
        } else if (object instanceof Enumeration) {
            Enumeration enumeration = (Enumeration)object;
            this.beginArray();
            while (enumeration.hasMoreElements()) {
                Object value = enumeration.nextElement();
                if (value != null) {
                    this.writeValue(value, object);
                    continue;
                }
                this.writeNull(true);
            }
            this.endArray();
        } else if (object.getClass().isArray()) {
            void var15_24;
            this.beginArray();
            int len = Array.getLength(object);
            boolean bl = false;
            while (var15_24 < len) {
                Object value = Array.get(object, (int)var15_24);
                if (value != null) {
                    this.writeValue(value, object);
                } else {
                    this.writeNull(true);
                }
                ++var15_24;
            }
            this.endArray();
        } else if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            if (this.stringifyContext != null) {
                this.writeString(this.stringifyContext.toString(localDateTime));
            } else {
                this.writeString(localDateTime.toString());
            }
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            if (this.stringifyContext != null) {
                this.writeString(this.stringifyContext.toString(localDate));
            } else {
                this.writeString(localDate.toString());
            }
        } else if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            if (this.stringifyContext != null) {
                this.writeString(this.stringifyContext.toString(localTime));
            } else {
                this.writeString(localTime.toString());
            }
        } else if (object instanceof Date) {
            Date date = (Date)object;
            if (this.stringifyContext != null) {
                this.writeString(this.stringifyContext.toString(date));
            } else {
                this.writeString(date.toString());
            }
        } else {
            String[] readablePropertyNames = BeanUtils.getReadablePropertyNamesWithoutNonSerializable(object);
            if (readablePropertyNames != null && readablePropertyNames.length > 0) {
                this.beginObject();
                for (String propertyName : readablePropertyNames) {
                    Object value;
                    try {
                        value = BeanUtils.getProperty(object, propertyName);
                    }
                    catch (InvocationTargetException e) {
                        throw new IOException(e);
                    }
                    this.writeName(propertyName);
                    this.writeValue(value, object);
                }
                this.endObject();
            } else {
                this.writeString(object.toString());
            }
        }
    }

    private void writeValue(Object object, Object container) throws IOException {
        this.checkCircularReference(container, object);
        this.upperObject = container;
        this.writeValue(object);
        this.upperObject = null;
    }

    public void writeNull() throws IOException {
        this.writeNull(false);
    }

    public void writeNull(boolean force) throws IOException {
        if (this.nullWritable || force) {
            this.writePendedName();
            this.writer.write(NULL_STRING);
            this.writtenFlags.update(true);
        } else {
            this.clearPendedName();
        }
    }

    public void writeJson(String json) throws IOException {
        if (this.nullWritable || json != null) {
            this.writePendedName();
            if (json != null) {
                String line;
                BufferedReader reader = new BufferedReader(new StringReader(json));
                boolean first = true;
                while ((line = reader.readLine()) != null) {
                    if (!first) {
                        this.nextLine();
                        this.indent();
                    }
                    this.writer.write(line);
                    first = false;
                }
            } else {
                this.writer.write(NULL_STRING);
            }
            this.writtenFlags.update(true);
        } else {
            this.clearPendedName();
        }
    }

    private void writeString(String value) throws IOException {
        if (this.nullWritable || value != null) {
            this.writePendedName();
            this.writer.write(JsonWriter.escape(value));
            this.writtenFlags.update(true);
        } else {
            this.clearPendedName();
        }
    }

    private void writeBool(Boolean value) throws IOException {
        if (this.nullWritable || value != null) {
            this.writePendedName();
            this.writer.write(value.toString());
            this.writtenFlags.update(true);
        } else {
            this.clearPendedName();
        }
    }

    private void writeNumber(Number value) throws IOException {
        if (this.nullWritable || value != null) {
            this.writePendedName();
            this.writer.write(value.toString());
            this.writtenFlags.update(true);
        } else {
            this.clearPendedName();
        }
    }

    private void writeComma() throws IOException {
        this.writer.write(",");
        this.nextLine();
    }

    private void indent() throws IOException {
        if (this.prettyPrint && this.indentString != null && !this.indentString.isEmpty()) {
            for (int i = 0; i < this.indentDepth; ++i) {
                this.writer.write(this.indentString);
            }
        }
    }

    private void nextLine() throws IOException {
        if (this.prettyPrint) {
            this.writer.write("\n");
        }
    }

    public void flush() throws IOException {
        this.writer.flush();
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public String toString() {
        return this.writer.toString();
    }

    private void checkCircularReference(Object object, Object member) throws IOException {
        if (object == member || this.upperObject != null && this.upperObject == member) {
            Object what = this.pendedName != null ? "member '" + this.pendedName + "'" : "a member";
            throw new IOException("JSON Serialization Failure: A circular reference was detected while converting " + (String)what);
        }
    }

    @NonNull
    private static String escape(String string) {
        if (string == null || string.isEmpty()) {
            return "\"\"";
        }
        int len = string.length();
        char c = '\u0000';
        StringBuilder sb = new StringBuilder(len + 4);
        sb.append('\"');
        block9: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                    sb.append(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        sb.append('\\');
                    }
                    sb.append(c);
                    continue block9;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block9;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block9;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block9;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block9;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block9;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        String t = "000" + Integer.toHexString(c);
                        sb.append("\\u").append(t.substring(t.length() - 4));
                        continue block9;
                    }
                    sb.append(c);
                }
            }
        }
        sb.append('\"');
        return sb.toString();
    }
}

