/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.nodelet;

import com.aspectran.utils.annotation.jsr305.NonNull;

public class NodeTracker
implements Cloneable {
    private String name;
    private int lineNumber;
    private int columnNumber;
    private NodeTracker clonedNodeTracker;

    public String getName() {
        return this.name;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setLocation(int lineNumber, int columnNumber) {
        this.lineNumber = lineNumber;
        this.columnNumber = columnNumber;
    }

    protected void update(@NonNull NodeTracker tracker) {
        this.setName(tracker.getName());
        this.setLocation(tracker.getLineNumber(), tracker.getColumnNumber());
    }

    public NodeTracker getClonedNodeTracker() {
        return this.clonedNodeTracker;
    }

    protected void setClonedNodeTracker(NodeTracker nodeTracker) {
        this.clonedNodeTracker = nodeTracker;
    }

    public NodeTracker clone() {
        NodeTracker tracker = new NodeTracker();
        tracker.setName(this.name);
        tracker.setLocation(this.lineNumber, this.columnNumber);
        this.setClonedNodeTracker(tracker);
        return tracker;
    }

    public String toString() {
        return "<" + this.name + "> [lineNumber: " + this.lineNumber + ", columnNumber: " + this.columnNumber + "]";
    }
}

