/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.security;

import com.aspectran.utils.PBEncryptionUtils;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.apon.AponReader;
import com.aspectran.utils.apon.Parameters;
import com.aspectran.utils.security.InvalidPBTokenException;

public class PBTokenIssuer {
    public String createToken(Parameters payload) {
        if (payload == null) {
            throw new IllegalArgumentException("payload must not be null");
        }
        return PBEncryptionUtils.encrypt(payload.toString());
    }

    public <T extends Parameters> T parseToken(String token) throws InvalidPBTokenException {
        return this.parseToken(token, null);
    }

    public <T extends Parameters> T parseToken(String token, @Nullable Class<T> payloadType) throws InvalidPBTokenException {
        if (StringUtils.isEmpty(token)) {
            throw new IllegalArgumentException("token must not be null or empty");
        }
        try {
            String payload = PBEncryptionUtils.decrypt(token);
            if (payloadType != null) {
                return (T)AponReader.read(payload, payloadType);
            }
            return (T)AponReader.read(payload);
        }
        catch (Exception e) {
            throw new InvalidPBTokenException(token, e);
        }
    }

    public static String getToken(Parameters payload) {
        PBTokenIssuer tokenIssuer = new PBTokenIssuer();
        return tokenIssuer.createToken(payload);
    }

    public static <T extends Parameters> T getPayload(String token) throws InvalidPBTokenException {
        return PBTokenIssuer.getPayload(token, null);
    }

    public static <T extends Parameters> T getPayload(String token, Class<T> payloadType) throws InvalidPBTokenException {
        PBTokenIssuer tokenIssuer = new PBTokenIssuer();
        return tokenIssuer.parseToken(token, payloadType);
    }
}

