/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.thread;

import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.thread.ThrowingRunnable;
import java.util.concurrent.Callable;

public abstract class ThreadContextHelper {
    @Nullable
    public static ClassLoader overrideClassLoader(@Nullable ClassLoader classLoader) {
        Thread currentThread;
        ClassLoader contextClassLoader;
        if (classLoader != null && !classLoader.equals(contextClassLoader = (currentThread = Thread.currentThread()).getContextClassLoader())) {
            currentThread.setContextClassLoader(classLoader);
            return contextClassLoader;
        }
        return null;
    }

    public static void restoreClassLoader(@Nullable ClassLoader classLoader) {
        if (classLoader != null) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public static void run(ClassLoader classLoader, @NonNull Runnable runnable) {
        ClassLoader old = ThreadContextHelper.overrideClassLoader(classLoader);
        try {
            runnable.run();
        }
        finally {
            ThreadContextHelper.restoreClassLoader(old);
        }
    }

    public static <T extends Throwable> void runThrowable(ClassLoader classLoader, @NonNull ThrowingRunnable<T> runnable) throws T {
        ClassLoader old = ThreadContextHelper.overrideClassLoader(classLoader);
        try {
            runnable.run();
        }
        finally {
            ThreadContextHelper.restoreClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V> V call(ClassLoader classLoader, @NonNull Callable<V> callable) throws Exception {
        ClassLoader old = ThreadContextHelper.overrideClassLoader(classLoader);
        try {
            V v = callable.call();
            return v;
        }
        finally {
            ThreadContextHelper.restoreClassLoader(old);
        }
    }
}

