/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.timer;

import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.logging.Logger;
import com.aspectran.utils.logging.LoggerFactory;
import com.aspectran.utils.thread.Scheduler;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.security.auth.Destroyable;

public abstract class CyclicTimeout
implements Destroyable {
    private static final Logger logger = LoggerFactory.getLogger(CyclicTimeout.class);
    private static final Timeout NOT_SET = new Timeout(Long.MAX_VALUE, null);
    private static final Scheduler.Task DESTROYED = () -> false;
    private final Scheduler scheduler;
    private final AtomicReference<Timeout> timeout = new AtomicReference<Timeout>(NOT_SET);

    public CyclicTimeout(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public boolean schedule(long delay, @NonNull TimeUnit units) {
        boolean result;
        Wakeup wakeup;
        Timeout timeout;
        long now = System.nanoTime();
        long newTimeoutAt = now + units.toNanos(delay);
        Wakeup newWakeup = null;
        do {
            timeout = this.timeout.get();
            result = timeout.at != Long.MAX_VALUE;
            wakeup = timeout.wakeup;
            if (wakeup != null && wakeup.at <= newTimeoutAt) continue;
            wakeup = newWakeup = new Wakeup(newTimeoutAt, wakeup);
        } while (!this.timeout.compareAndSet(timeout, new Timeout(newTimeoutAt, wakeup)));
        if (logger.isTraceEnabled()) {
            logger.trace("Installed timeout in " + units.toMillis(delay) + " ms, " + (newWakeup != null ? "new" : "existing") + " waking up in " + TimeUnit.NANOSECONDS.toMillis(wakeup.at - now) + " ms");
        }
        if (newWakeup != null) {
            newWakeup.schedule(now);
        }
        return result;
    }

    public boolean cancel() {
        boolean result;
        Wakeup wakeup;
        Timeout newTimeout;
        Timeout timeout;
        do {
            timeout = this.timeout.get();
            result = timeout.at != Long.MAX_VALUE;
        } while (!this.timeout.compareAndSet(timeout, newTimeout = (wakeup = timeout.wakeup) == null ? NOT_SET : new Timeout(Long.MAX_VALUE, wakeup)));
        return result;
    }

    public abstract void onTimeoutExpired();

    @Override
    public void destroy() {
        Wakeup wakeup;
        Timeout timeout = this.timeout.getAndSet(NOT_SET);
        Wakeup wakeup2 = wakeup = timeout != null ? timeout.wakeup : null;
        while (wakeup != null) {
            wakeup.destroy();
            wakeup = wakeup.next;
        }
    }

    private static class Timeout {
        private final long at;
        private final Wakeup wakeup;

        private Timeout(long timeoutAt, Wakeup wakeup) {
            this.at = timeoutAt;
            this.wakeup = wakeup;
        }

        @NonNull
        public String toString() {
            return String.format("%s@%x:%dms,%s", this.getClass().getSimpleName(), this.hashCode(), TimeUnit.NANOSECONDS.toMillis(this.at), this.wakeup);
        }
    }

    private class Wakeup
    implements Runnable {
        private final AtomicReference<Scheduler.Task> task = new AtomicReference();
        private final long at;
        private final Wakeup next;

        private Wakeup(long wakeupAt, Wakeup next) {
            this.at = wakeupAt;
            this.next = next;
        }

        private void schedule(long now) {
            this.task.compareAndSet(null, CyclicTimeout.this.scheduler.schedule(this, this.at - now, TimeUnit.NANOSECONDS));
        }

        private void destroy() {
            Scheduler.Task task = this.task.getAndSet(DESTROYED);
            if (task != null) {
                task.cancel();
            }
        }

        @Override
        public void run() {
            Timeout newTimeout;
            Timeout timeout;
            long now = System.nanoTime();
            Wakeup newWakeup = null;
            boolean hasExpired = false;
            do {
                timeout = CyclicTimeout.this.timeout.get();
                Wakeup wakeup = timeout.wakeup;
                while (wakeup != null && wakeup != this) {
                    wakeup = wakeup.next;
                }
                if (wakeup == null) {
                    return;
                }
                wakeup = wakeup.next;
                if (timeout.at <= now) {
                    hasExpired = true;
                    newTimeout = wakeup == null ? NOT_SET : new Timeout(Long.MAX_VALUE, wakeup);
                    continue;
                }
                if (timeout.at != Long.MAX_VALUE) {
                    if (wakeup == null || wakeup.at > timeout.at) {
                        wakeup = newWakeup = new Wakeup(timeout.at, wakeup);
                    }
                    newTimeout = new Timeout(timeout.at, wakeup);
                    continue;
                }
                Timeout timeout2 = newTimeout = wakeup == null ? NOT_SET : new Timeout(Long.MAX_VALUE, wakeup);
            } while (!CyclicTimeout.this.timeout.compareAndSet(timeout, newTimeout));
            if (newWakeup != null) {
                newWakeup.schedule(now);
            }
            if (hasExpired) {
                CyclicTimeout.this.onTimeoutExpired();
            }
        }

        @NonNull
        public String toString() {
            return String.format("%s@%x:%dms->%s", this.getClass().getSimpleName(), this.hashCode(), this.at == Long.MAX_VALUE ? this.at : TimeUnit.NANOSECONDS.toMillis(this.at), this.next);
        }
    }
}

