/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.wildcard;

import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.wildcard.WildcardPattern;
import com.aspectran.utils.wildcard.WildcardPatterns;

public class RelativeComplementWildcardPatterns {
    private final WildcardPatterns includePatterns;
    private final WildcardPatterns excludePatterns;

    private RelativeComplementWildcardPatterns(WildcardPatterns includePatterns, WildcardPatterns excludePatterns) {
        this.includePatterns = includePatterns;
        this.excludePatterns = excludePatterns;
    }

    public WildcardPattern[] getIncludePatterns() {
        return this.includePatterns != null ? this.includePatterns.getPatterns() : null;
    }

    public boolean hasIncludePatterns() {
        return this.includePatterns != null && this.includePatterns.hasPatterns();
    }

    public WildcardPattern[] getExcludePatterns() {
        return this.excludePatterns != null ? this.excludePatterns.getPatterns() : null;
    }

    public boolean hasExcludePatterns() {
        return this.excludePatterns != null && this.excludePatterns.hasPatterns();
    }

    public boolean matches(CharSequence input) {
        boolean result;
        boolean bl = result = this.includePatterns == null || this.includePatterns.matches(input);
        if (result && this.excludePatterns != null) {
            result = !this.excludePatterns.matches(input);
        }
        return result;
    }

    @NonNull
    public static RelativeComplementWildcardPatterns of(WildcardPattern[] includePatterns, WildcardPattern[] excludePatterns) {
        return new RelativeComplementWildcardPatterns(WildcardPatterns.of(includePatterns), WildcardPatterns.of(excludePatterns));
    }

    @NonNull
    public static RelativeComplementWildcardPatterns of(String[] includePatterns, String[] excludePatterns) {
        return new RelativeComplementWildcardPatterns(WildcardPatterns.of(includePatterns), WildcardPatterns.of(excludePatterns));
    }

    @NonNull
    public static RelativeComplementWildcardPatterns of(String[] includePatterns, String[] excludePatterns, char separator) {
        return new RelativeComplementWildcardPatterns(WildcardPatterns.of(includePatterns, separator), WildcardPatterns.of(excludePatterns, separator));
    }
}

