/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.utils.wildcard;

import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.utils.annotation.jsr305.Nullable;
import com.aspectran.utils.wildcard.WildcardPattern;
import java.util.ArrayList;

public class WildcardPatterns {
    private final WildcardPattern[] patterns;

    private WildcardPatterns(@NonNull WildcardPattern[] patterns) {
        this.patterns = patterns;
    }

    @NonNull
    public WildcardPattern[] getPatterns() {
        return this.patterns;
    }

    public boolean hasPatterns() {
        return this.patterns.length > 0;
    }

    public boolean matches(CharSequence input) {
        for (WildcardPattern pattern : this.patterns) {
            if (!pattern.matches(input)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    static WildcardPatterns of(WildcardPattern[] patterns) {
        if (patterns == null || patterns.length == 0) {
            return null;
        }
        return new WildcardPatterns(patterns);
    }

    @Nullable
    public static WildcardPatterns of(String[] patterns) {
        return WildcardPatterns.of(patterns, '\u0000');
    }

    @Nullable
    public static WildcardPatterns of(String[] patterns, char separator) {
        if (patterns == null || patterns.length == 0) {
            return null;
        }
        ArrayList<WildcardPattern> list = new ArrayList<WildcardPattern>(patterns.length);
        for (String pattern : patterns) {
            if (pattern == null || pattern.isEmpty()) continue;
            WildcardPattern wildcardPattern = new WildcardPattern(pattern, separator);
            list.add(wildcardPattern);
        }
        if (!list.isEmpty()) {
            return WildcardPatterns.of(list.toArray(new WildcardPattern[0]));
        }
        return null;
    }
}

