/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.activity;

import com.aspectran.core.activity.Activity;
import com.aspectran.core.activity.ActivityPrepareException;
import com.aspectran.core.activity.ActivityTerminatedException;
import com.aspectran.core.activity.AdapterException;
import com.aspectran.core.activity.CoreActivity;
import com.aspectran.core.activity.TransletNotFoundException;
import com.aspectran.core.activity.request.RequestParseException;
import com.aspectran.core.context.rule.TransletRule;
import com.aspectran.core.context.rule.type.MethodType;
import com.aspectran.utils.Assert;
import com.aspectran.utils.StringUtils;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.web.activity.request.WebRequestBodyParser;
import com.aspectran.web.adapter.HttpServletRequestAdapter;
import com.aspectran.web.adapter.HttpServletResponseAdapter;
import com.aspectran.web.adapter.HttpSessionAdapter;
import com.aspectran.web.adapter.WebRequestAdapter;
import com.aspectran.web.service.WebService;
import com.aspectran.web.support.http.MediaType;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.UnsupportedEncodingException;

public class WebActivity
extends CoreActivity {
    private final String reverseContextPath;
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private String requestName;
    private MethodType requestMethod;
    private boolean async;
    private Long timeout;

    public WebActivity(@NonNull WebService webService, String contextPath, String reverseContextPath, HttpServletRequest request, HttpServletResponse response) {
        super(webService.getActivityContext(), contextPath);
        this.reverseContextPath = reverseContextPath;
        this.request = request;
        this.response = response;
    }

    @Override
    public Activity.Mode getMode() {
        return Activity.Mode.WEB;
    }

    @Override
    public String getReverseContextPath() {
        return this.reverseContextPath;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public String getRequestName() {
        return this.requestName;
    }

    public void setRequestName(String requestName) {
        this.requestName = requestName;
    }

    public MethodType getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(MethodType requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getFullRequestName() {
        StringBuilder sb = new StringBuilder();
        if (this.requestMethod != null) {
            sb.append((Object)this.requestMethod).append(" ");
        }
        if (StringUtils.hasLength(this.reverseContextPath)) {
            sb.append(this.reverseContextPath);
        }
        if (this.requestName != null) {
            sb.append(this.requestName);
        }
        return sb.toString();
    }

    public boolean isAsync() {
        return this.async;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public void prepare() throws TransletNotFoundException, ActivityPrepareException {
        Assert.state(this.requestName != null, "requestName is not set");
        Assert.state(this.requestMethod != null, "requestMethod is not set");
        this.prepare(this.requestName, this.requestMethod);
    }

    @Override
    protected void prepare(String requestName, MethodType requestMethod, @NonNull TransletRule transletRule) throws ActivityPrepareException {
        MethodType hiddenRequestMethod;
        String method;
        this.async = transletRule.isAsync();
        this.timeout = transletRule.getTimeout();
        if (requestMethod == MethodType.POST && (method = this.request.getHeader("X-Method-Override")) != null && (hiddenRequestMethod = MethodType.resolve(method)) != null) {
            requestMethod = hiddenRequestMethod;
        }
        super.prepare(requestName, requestMethod, transletRule);
    }

    @Override
    protected void adapt() throws AdapterException {
        try {
            String responseEncoding;
            HttpSessionAdapter sessionAdapter = new HttpSessionAdapter(this.request);
            this.setSessionAdapter(sessionAdapter);
            HttpServletRequestAdapter requestAdapter = new HttpServletRequestAdapter(this.getTranslet().getRequestMethod(), this.request);
            if (this.getParentActivity() == null) {
                String requestEncoding;
                String maxRequestSizeSetting = (String)this.getSetting("maxRequestSize");
                if (StringUtils.hasLength(maxRequestSizeSetting)) {
                    try {
                        long maxRequestSize = Long.parseLong(maxRequestSizeSetting);
                        if (maxRequestSize >= 0L) {
                            requestAdapter.setMaxRequestSize(maxRequestSize);
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new RequestParseException("Illegal value for maxRequestSize: " + maxRequestSizeSetting, e);
                    }
                }
                if ((requestEncoding = this.getDefinitiveRequestEncoding()) != null) {
                    try {
                        requestAdapter.setEncoding(requestEncoding);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new RequestParseException("Unable to set request encoding to " + requestEncoding, e);
                    }
                }
            }
            this.setRequestAdapter(requestAdapter);
            HttpServletResponseAdapter responseAdapter = new HttpServletResponseAdapter(this.response, this);
            if (this.getParentActivity() == null && (responseEncoding = this.getDefinitiveResponseEncoding()) != null) {
                responseAdapter.setEncoding(responseEncoding);
            }
            this.setResponseAdapter(responseAdapter);
        }
        catch (Exception e) {
            throw new AdapterException("Failed to adapt for the web activity", e);
        }
        super.adapt();
    }

    @Override
    public WebRequestAdapter getRequestAdapter() {
        return (WebRequestAdapter)super.getRequestAdapter();
    }

    @Override
    protected void parseRequest() throws RequestParseException, ActivityTerminatedException {
        if (this.getParentActivity() == null) {
            this.getRequestAdapter().preparse();
        } else {
            this.getRequestAdapter().preparse((WebRequestAdapter)this.getParentActivity().getRequestAdapter());
        }
        MediaType mediaType = this.getRequestAdapter().getMediaType();
        if (mediaType != null) {
            if (WebRequestBodyParser.isMultipartForm(this.getRequestAdapter().getRequestMethod(), mediaType)) {
                WebRequestBodyParser.parseMultipartFormData(this);
            } else if (WebRequestBodyParser.isURLEncodedForm(mediaType)) {
                WebRequestBodyParser.parseURLEncodedFormData(this.getRequestAdapter());
            }
        }
        super.parseRequest();
    }
}

