/*
 * Decompiled with CFR 0.152.
 */
package com.aspectran.web.activity.request;

import com.aspectran.core.adapter.RequestAdapter;
import com.aspectran.utils.annotation.jsr305.NonNull;
import com.aspectran.web.activity.request.RequestAttributeMap;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ActivityRequestWrapper
extends HttpServletRequestWrapper {
    private final RequestAdapter requestAdapter;

    public ActivityRequestWrapper(@NonNull RequestAdapter requestAdapter) {
        super((HttpServletRequest)requestAdapter.getAdaptee());
        this.requestAdapter = requestAdapter;
    }

    public void setRequest(@NonNull ServletRequest request) {
        super.setRequest(request);
        Map<String, Object> attributeMap = this.requestAdapter.getAttributeMap();
        if (attributeMap instanceof RequestAttributeMap) {
            RequestAttributeMap requestAttributeMap = (RequestAttributeMap)attributeMap;
            requestAttributeMap.setRequest(request);
        }
    }

    public String getHeader(String name) {
        return this.requestAdapter.getHeader(name);
    }

    public Enumeration<String> getHeaders(String name) {
        List<String> values = this.requestAdapter.getHeaderValues(name);
        if (values != null) {
            return Collections.enumeration(this.requestAdapter.getHeaderValues(name));
        }
        return Collections.emptyEnumeration();
    }

    public Enumeration<String> getHeaderNames() {
        Set<String> names = this.requestAdapter.getHeaderNames();
        if (names != null) {
            return Collections.enumeration(this.requestAdapter.getHeaderNames());
        }
        return Collections.emptyEnumeration();
    }

    public Object getAttribute(String name) {
        return this.requestAdapter.getAttribute(name);
    }

    public Enumeration<String> getAttributeNames() {
        Set<String> names = this.requestAdapter.getAttributeNames();
        if (names != null) {
            return Collections.enumeration(this.requestAdapter.getAttributeNames());
        }
        return Collections.emptyEnumeration();
    }

    public void setAttribute(String name, Object o) {
        this.requestAdapter.setAttribute(name, o);
    }

    public void removeAttribute(String name) {
        this.requestAdapter.removeAttribute(name);
    }

    public String getParameter(String name) {
        return this.requestAdapter.getParameter(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.requestAdapter.getParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        Collection<String> names = this.requestAdapter.getParameterNames();
        if (names != null) {
            return Collections.enumeration(this.requestAdapter.getParameterNames());
        }
        return Collections.emptyEnumeration();
    }

    public String[] getParameterValues(String name) {
        return this.requestAdapter.getParameterValues(name);
    }

    public Locale getLocale() {
        if (this.requestAdapter.getLocale() == null) {
            return super.getLocale();
        }
        return this.requestAdapter.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        if (this.requestAdapter.getLocale() == null) {
            return super.getLocales();
        }
        return Collections.enumeration(Collections.singleton(this.requestAdapter.getLocale()));
    }
}

